/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* link.h -- Structure to draw links between jobs into a GnomeCanvas */

#ifndef _LINK_H
#define _LINK_H

struct str_link;
typedef struct str_link link_t;


#include <schedwi.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <libgnomecanvas/libgnomecanvas.h>
#include <child_job.h>
#include <jobset_item.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct str_link {
	child_job_t *src;
	child_job_t *dst;
	job_status_state link_type;
	gboolean selected;
	GnomeCanvasItem *line_item;
	GnomeCanvasItem *line_item_select;
	const GdkColor *line_color[NUM_HIGHLIGHT_MODES];
};


extern void destroy_link OF((link_t *ptr));
extern void destroy_link_list OF((GSList *list));
extern link_t * new_link OF((	GSList *jobs,
				const gchar *id_src, const gchar *id_dst,
				job_status_state link_type));
extern link_t * new_link_jobs OF((child_job_t *src, child_job_t *dst,
				job_status_state link_type));
extern GSList *get_link_list OF((GSList *jobs, int workload_date));
extern void link_draw OF((link_t *ptr, GnomeCanvasGroup *group));
extern void link_draw_list OF((GSList *list, GnomeCanvasGroup *group));
extern void link_unselect OF((link_t *ptr));
extern void link_select OF((link_t *ptr));
extern link_t *link_find OF((	GSList *list,
				const gchar *job_src,
				const char *job_dst));
extern gboolean link_delete OF((link_t *ptr));
extern void link_menu_delete OF((GtkMenuItem *item));
extern void link_menu_change_type OF((	GtkMenuItem *item,
					job_status_state new_link_type));

#define link_menu_change_completed(w) link_menu_change_type((w),JOB_STATUS_STATE_COMPLETED)
#define link_menu_change_failed(w) link_menu_change_type((w),JOB_STATUS_STATE_FAILED)
#define link_menu_change_running(w) link_menu_change_type((w),JOB_STATUS_STATE_RUNNING)
#define link_menu_change_waiting(w) link_menu_change_type((w),JOB_STATUS_STATE_WAITING)


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* link.h */

/*-----------------============== End Of File ==============-----------------*/
