/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* login_cb.c -- GUI functions for the login window */

#include <schedwi.h>

#include <schedwi_interface.h>

#include <sql_common.h>
#include <message_windows.h>
#include <main_cb.h>
#include <cursor.h>
#include <schedwi_gconf.h>
#include <conf_gui.h>

#include <login_cb.h>


/*
 * Logout
 */
void
login_logout (GtkWidget *application_main)
{
	destroy_db_connection ();
	main_clear (application_main);
}


/*
 * Callback for the `Login' button
 */
void
login_clicked (GtkButton *button)
{
	GtkWidget *username_w, *password_w, *dialog_w, *main_w;
	gchar *host, *database, *socket_file, *user_name;
	gint port;
	const gchar *user, *password;
	char *err_msg = NULL;

	cursor_busy (GTK_WIDGET (button));

	/* Retrieve the database connection parameters */
	host = gconf_client_get_string (schedwi_gconf,
					GCONF_PATH "/database/host",
					NULL);
	database = gconf_client_get_string (schedwi_gconf,
					GCONF_PATH "/database/database",
					NULL);
	port = gconf_client_get_int (	schedwi_gconf,
					GCONF_PATH "/database/port",
					NULL);
	socket_file = gconf_client_get_string (schedwi_gconf,
					GCONF_PATH "/database/socket",
					NULL);
	username_w = lookup_widget (	GTK_WIDGET (button),
					"entry_login_username");
	password_w = lookup_widget (	GTK_WIDGET (button),
					"entry_login_password");
	user = gtk_entry_get_text (GTK_ENTRY (username_w));
	password = gtk_entry_get_text (GTK_ENTRY (password_w));
	
	/* Initialize the configuration structure */
	if (conf_init_gui (	host,
				(user == NULL || user[0] == '\0')? NULL: user,
				(password == NULL || password[0] == '\0')? NULL
								: password,
				database, (long int)port, socket_file) != 0)
	{
		g_free (host);
		g_free (database);
		g_free (socket_file);
		cursor_normal (GTK_WIDGET (button));
		error_window (_("Login failed"), _("Memory allocation error"));
		return;
	}
	g_free (host);
	g_free (database);
	g_free (socket_file);

	/* Close any existing database connection */
	dialog_w = lookup_widget (GTK_WIDGET (button), "dialog_login");
	main_w = g_object_get_data (G_OBJECT (dialog_w), "user_widget");
	login_logout (main_w);

	/* Establish a new connection */
	if (begin_mysql (&err_msg) == NULL) {
		cursor_normal (GTK_WIDGET (button));
		error_window (_("Login failed"), err_msg);
		if (err_msg != NULL) {
			free (err_msg);
		}
		return;
	}

	/* Copy the user name */
	user_name = g_strdup (user);

	/* Destroy the login window and initialize the main window */
	cursor_normal (GTK_WIDGET (button));
	gtk_widget_destroy (dialog_w);
	main_init (main_w, user_name);
	g_free (user_name);
}


/*
 * Build the new window
 */
static gint
dialog_login_build (GtkWidget *main_window)
{
	GtkWidget *username_w;
	gchar *username;

	username_w = lookup_widget (main_window, "entry_login_username");
	username = gconf_client_get_string (schedwi_gconf,
					GCONF_PATH "/database/username",
					NULL);
	if (username != NULL) {
		gtk_entry_set_text (GTK_ENTRY (username_w), username);
		g_free (username);
	}

	return 0;
}


/*
 * Create the password window
 *
 * Return:
 *   The new GtkWidget (`show'ed by this function) or
 *   NULL in case of error (an error message has been displayed for the user)
 */
GtkWidget *
new_dialog_login (GtkWidget *user_widget)
{
	GtkWidget *widget;

	widget = create_dialog_login ();
	if (dialog_login_build (widget) != 0) {
		gtk_widget_destroy (widget);
		return NULL;
	}
	else {
		g_object_set_data (	G_OBJECT (widget),
					"user_widget", user_widget);
		gtk_widget_show (widget);
		return widget;
	}
}

/*------------------------======= End Of File =======------------------------*/
