/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* main_cb.h -- GUI functions for the main window */

#ifndef _MAIN_CB_H
#define _MAIN_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *application_main;
extern GnomeAppBar *application_statusbar;
extern gchar *user_name;

extern GtkWidget *new_dialog_main OF(());
extern gboolean main_init OF((GtkWidget *main_window, const gchar *user));
extern void main_clear OF((GtkWidget *main_window));
extern void zoom_in OF((GtkWidget *w));
extern void zoom_out OF((GtkWidget *w));
extern void zoom_normal OF((GtkWidget *w));
extern void show_hide_grid OF((GtkWidget *w, gboolean activate));
extern void snap_grid OF((GtkWidget *w, gboolean snap));
extern gboolean canvas_main_scroll_event OF((	GtkWidget *w,
						GdkEventScroll *event));
extern void jobset_list_refresh OF((GtkWidget *w));
extern void main_location_changed OF((const gchar *path, GtkWidget *w));
extern void main_select_job OF((GtkWidget *w, const gchar *id,
				const gchar *parent_id,
				const gchar *job_type));
extern void main_cb_cut OF((GtkWidget *w));
extern void main_cb_copy OF((GtkWidget *w));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* main_cb.h */

/*-----------------============== End Of File ==============-----------------*/
