/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* message_windows.h -- Message dialog windows */

#ifndef _MESSAGE_WINDOWS_H
#define _MESSAGE_WINDOWS_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void error_window OF((	const char *primary_text,
				const char *error_message));
extern void warning_window OF((	const char *primary_text,
				const char *warning_message));
extern void error_window_ignore_errno OF((	const char *primary_text,
						const char *error_message,
						unsigned int sql_errno));
extern void error_window_check_duplicate OF((	const char *primary_text,
						const char *error_message,
						unsigned int sql_errno));
extern void info_window OF((	const char *primary_text,
				const char *info_message));
extern gboolean question_delete_window OF((	GtkWidget *parent,
						const char *message));
extern gboolean question_replace_window OF((	GtkWidget *parent,
						const char *primary_text,
						const char *secondary_text));
extern gboolean question_window OF((	GtkWidget *parent,
					const char *primary_text,
					const char *secondary_text));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* message_windows.h */

/*-----------------============== End Of File ==============-----------------*/
