/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_g_utils.c -- Useful functions */

#include <schedwi.h>

#include <lib_functions.h>
#include <schedwi_g_utils.h>

/*
 * Convert a guint64 to a string
 *
 * Return:
 *   A newly allocated string (to be freed by the caller)
 */
gchar *
schedwi_ulltostr (guint64 v)
{
	gchar *str;
	gint i;

	str = (gchar *) g_malloc (sizeof (gchar) * 25);
	i = 0;
	do {
		str[i++] = '0' + v % 10;
		v /= 10;
	} while (v > 0);
	str[i] = '\0';
	return g_strreverse (str);
}


/*
 * Remove the last needle string from haystack.  If needle is not found, a copy
 * of haystack is returned.  needle must be on a line by itself.
 *
 * Return:
 *   A newly allocated string containing haystack without needle.  This new
 *   string must be freed by the caller (g_free())
 */
gchar *
remove_string (const gchar *haystack, const gchar *needle)
{
	gchar *s, *tmp, *ret;
	gsize len;

	len = (gsize)schedwi_strlen (needle);
	s = g_strrstr (haystack, needle);

	/* needle not found or not on a line by itself */
	if (	   s == NULL
		|| (s != haystack && *(s - 1) != '\n')
		|| (s[len] != '\0' && s[len] != '\n'))
	{
		/* Return a copy */
		return g_strdup (haystack);
	}

	tmp = g_strndup (haystack, s - haystack - ((s != haystack) ? 1: 0));
	ret = g_strconcat (tmp, s + len,  NULL);
	g_free (tmp);
	return ret;
}

gboolean
search_string (const gchar *haystack, const gchar *needle)
{
	gchar *s;
	gsize len;

	len = (gsize)schedwi_strlen (needle);
	s = g_strrstr (haystack, needle);

	/* needle not found or not on a line by itself */
	if (	   s == NULL
		|| (s != haystack && *(s - 1) != '\n')
		|| (s[len] != '\0' && s[len] != '\n'))
	{
		return FALSE;
	}
	return TRUE;
}

/*------------------------======= End Of File =======------------------------*/
