/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * schedwi_style.c -- Get the background/foreground colors to use for canvas
 *                    items.
 */

#include <schedwi.h>
#include <schedwi_style.h>

#define SCHEDWI_STYLE_DEFAULT_BASE_NORMAL "#FFFFFF"
#define SCHEDWI_STYLE_DEFAULT_BASE_PRELIGHT "#FFFFFF"
#define SCHEDWI_STYLE_DEFAULT_BASE_SELECTED "#0000FF"
#define SCHEDWI_STYLE_DEFAULT_TEXT_NORMAL "#000000"
#define SCHEDWI_STYLE_DEFAULT_TEXT_PRELIGHT "#000000"
#define SCHEDWI_STYLE_DEFAULT_TEXT_SELECTED "#FFFFFF"


/* Style to use for the canvas items */
static GtkStyle *schedwi_style = NULL;


/*
 * Destroy the style
 */
void
schedwi_style_destroy ()
{
	if (schedwi_style != NULL) {
		g_object_unref ((gpointer) schedwi_style);
	}
}


/*
 * Initialize the style for canvas items.  The provided widget should be
 * a GtkEntry.  It is used to retrieve the style to use.
 */
void
schedwi_style_init (GtkWidget *w)
{
	schedwi_style_destroy ();

	schedwi_style = gtk_rc_get_style_by_paths (
				gtk_widget_get_settings (w),
				NULL,
				"GtkEntry",
				G_TYPE_NONE);
	if (schedwi_style == NULL) {
		schedwi_style = gtk_rc_get_style (w);
		if (schedwi_style == NULL) {
			schedwi_style = gtk_widget_get_default_style ();
		}
	}
	if (schedwi_style != NULL) {
		g_object_ref ((gpointer) schedwi_style);
	}
}


/*
 * Get the base color (background) for the provided state.  *color is filed
 * with the associated color
 */
void
schedwi_style_get_base_color (GtkStateType state_type, GdkColor *color)
{
	if (schedwi_style != NULL) {
		*color = schedwi_style->base[state_type];
	}
	else {
		switch (state_type) {
			case GTK_STATE_PRELIGHT:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_BASE_PRELIGHT,
					color);
				break;
			case GTK_STATE_SELECTED:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_BASE_NORMAL,
					color);
				break;
			default:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_BASE_SELECTED,
					color);
				break;
		}
	}
}


/*
 * Get the text color for the provided state.  *color is filed
 * with the associated color
 */
void
schedwi_style_get_text_color (GtkStateType state_type, GdkColor *color)
{
	if (schedwi_style != NULL) {
		*color = schedwi_style->text[state_type];
	}
	else {
		switch (state_type) {
			case GTK_STATE_PRELIGHT:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_TEXT_PRELIGHT,
					color);
				break;
			case GTK_STATE_SELECTED:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_TEXT_NORMAL,
					color);
				break;
			default:
				gdk_color_parse (
					SCHEDWI_STYLE_DEFAULT_TEXT_SELECTED,
					color);
				break;
		}
	}
}

/*-----------------============== End Of File ==============-----------------*/
