/*      $NetBSD: htonl.c,v 1.11 2003/12/04 13:57:31 keihan Exp $        */
/*
 * Written by J.T. Conklin <jtc@NetBSD.org>.
 * Public domain.
 */

#include <schedwi.h>

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#include <sys/cdefs.h>

#include <endian.h>

#ifndef HAVE_UINTXX_T
typedef u_int32_t uint32_t;
#endif

#undef htonl

uint32_t
htonl(x)
         uint32_t x;
{
#if BYTE_ORDER == LITTLE_ENDIAN
        u_char *s = (u_char *)&x;
        return (uint32_t)(s[0] << 24 | s[1] << 16 | s[2] << 8 | s[3]);
#else
        return x;
#endif
}

