/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * lwc_log.c -- Function to log messages
 */

#ifndef _LWC_LOG_H
#define _LWC_LOG_H

#include <schedwi.h>

#if HAVE_STDARG_H
#include <stdarg.h>
#endif

#if HAVE_SYSLOG_H
#include <syslog.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int  lwc_newLog   OF((	const char * ident,
				char inSyslog,
				int facility,
				const char * logFileName,
				const char * dateFmt));
extern int  lwc_closeLog OF(());
extern void lwc_writeLog OF((int level, const char * format, ...));
extern void lwc_vwriteLog OF((int level, const char * format, va_list ap));

#ifdef __cplusplus
}
#endif

#endif /* _LWC_LOG_H */

/******************************** End Of File ********************************/
