/* Schedwi
   Copyright (C) 2010, 2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * parse_json_result.h -- Parse the JSON string which contains the result
 * sent by the other end to a request.
 * The JSON string looks like:
 *     {
 *         "success" : false,
 *          "data" : "Database unavailable"
 *     }
 * OR
 *     {
 *         "success" : false,
 *         "reason" : 2,
 *          "data" : "Certificate still not ready"
 *     }
 */


#ifndef _PARSE_JSON_RESULT_H
#define _PARSE_JSON_RESULT_H

#include <schedwi.h>
#include <reg_error_code.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int parse_json_result OF((	const char *json_string,
					ssize_t json_string_length,
					char **result_msg,
					error_reason_t *reason));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* parse_json_result.h */

/*-----------------============== End Of File ==============-----------------*/
