/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * parsevar.h -- Parse an environment array
 *
 * The `parse_param' function is used to parse an environment array, doing
 * all the variable substitutions.  A new environment array is built and
 * returned.
 * The input environment array is an array of strings.  These strings have
 * the form `name=value'.  The array is terminated by a NULL pointer.
 * The output environment array has the same format but is embedded in a
 * environment_t structure (it's the env member of the structure).
 *
 * In the value part of each environment variable, parameter substitutions
 * are done using a similar syntax of the bash shell parameter expansion
 * (with limitations):
 *     $parameter or ${parameter}
 *           The  value of `parameter' is substituted.  The braces are required
 *           when `parameter' is followed by a character which is not to be
 *           interpreted as part of its name.
 *     ${parameter:-word}
 *           If `parameter' is unset or null, the expansion of `word' is
 *           substituted.  Otherwise, the value of `parameter' is
 *           substituted.
 *     ${parameter:=word}
 *           If `parameter' is unset or null, the expansion of `word' is
 *           assigned to `parameter'.  The value of `parameter' is then
 *           substituted.
 *     ${parameter:?word}
 *           If `parameter' is unset or null, the expansion of `word' is
 *           substituted if not empty.  Otherwise the string `parameter
 *           null or n ot set' is substituted.  THIS IS A DIFFERENT BEHAVIOR
 *           than bash.
 *     ${parameter:+word}
 *           If `parameter' is unset or null, nothing is substituted,
 *           otherwise the expansion of `word' is substituted.
 */

#ifndef _PARSEVAR_H
#define _PARSEVAR_H

#include <schedwi.h>

#include <env_utils.h>
#include <args_utils.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int parse_param OF((const environment_t *env, environment_t *new_env,
				int *error_idx));
extern int parse_string OF((const char *string, size_t string_len,
			environment_t *env, char **out, size_t *out_len));
extern int parse_args OF((	const argument_t *arg, argument_t *new_arg,
				environment_t *env, int *error_idx));
extern int check_key_syntax OF((const char *key));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* parsevar.h */

/*-----------------============== End Of File ==============-----------------*/
