# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to change calendars or calendar groups parameters."""

import sys
import getopt

import path_cal
import set_options
from tables.calendars import calendars

def set(sql_session, current_cwd, arguments):
    """Change a calendar/directory parameters.

    Arguments:
    sql_session -- SQLAlchemy session
    current_cwd -- current working directory (a path_cal.PathCal object)
    arguments -- list of arguments given to the set command (list of calendars)

    """
    # Parse the parameters
    try:
        optlist, args = set_options.parse_args(arguments)
    except getopt.GetoptError, err:
        sys.stderr.write("set: " + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            set_options.usage()
            return 0
    paths = list()
    if args:
        for arg in args:
            paths.extend (path_cal.get_paths(sql_session, arg, current_cwd))
    else:
        sys.stderr.write("set: missing calendar or directory name\n")
        return 1
    if not paths:
        sys.stderr.write("set: no such calendar or directory\n")
        return 1
    session = sql_session.open_session()
    error = False
    for p in paths:
        try:
            cal = session.query(calendars).filter_by(id=p.id[-1]).one()
        except:
            sys.stderr.write("set: `%s': no such calendar or directory\n" % p)
            error = True
            continue
        if set_options.set(session, cal, optlist):
            sql_session.cancel_session(session)
            return 1
    sql_session.close_session(session)
    return 0 if not error else 1

