# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to change environment group parameters."""

import sys
import getopt

import sqlalchemy.exc

import set_options
import environments_utils

def set(sql_session, arguments, workload=None):
    """Change environment group parameters.
    
    Arguments:
    sql_session -- SQLAlchemy session
    arguments -- list of arguments given to the set command (list of env groups)
    workload -- workload to use

    """
    # Parse the parameters
    try:
        optlist, args = set_options.parse_args(arguments)
    except getopt.GetoptError, err:
        sys.stderr.write("set: " + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            set_options.usage()
            return 0
    if not args:
        sys.stderr.write("set: missing operand\n")
        return 1
    session = sql_session.open_session()
    error = False
    for a in args:
        env_list = environments_utils.name2env_list(session, a, workload)
        if not env_list:
            if  filter(lambda i: i[0] in ('-h', '--help'), optlist):
                set_options.usage()
                sql_session.cancel_session(session)
                return 0
            sys.stderr.write("set: `%s': no such environment group\n" % a)
            error = True
        else:
            for e in env_list:
                if set_options.set(session, e, optlist, workload):
                    error = True
    if error:
        sql_session.cancel_session(session)
        return 1
    try:
        sql_session.close_session(session)
    except sqlalchemy.exc.IntegrityError:
        # Duplicate
        sql_session.cancel_session(session)
        sys.stderr.write(
                "set: an environment group with this name already exists\n")
        return 1
    return 0

