# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Command line colorization."""

import os
try:
    import curses
except ImportError:
    WITH_COLORS = False
else:
    if os.isatty(1):
        WITH_COLORS = True
    else:
        WITH_COLORS = False

if WITH_COLORS:
    curses.setupterm()
    bgColorSeq = curses.tigetstr('setab') or curses.tigetstr('setb') or ''
    BLUE = curses.tparm(bgColorSeq, curses.COLOR_BLUE)
    GREEN = curses.tparm(bgColorSeq, curses.COLOR_GREEN)
    CYAN = curses.tparm(bgColorSeq, curses.COLOR_CYAN)
    RED = curses.tparm(bgColorSeq, curses.COLOR_RED)
    MAGENTA = curses.tparm(bgColorSeq, curses.COLOR_MAGENTA)
    YELLOW = curses.tparm(bgColorSeq, curses.COLOR_YELLOW)
    WHITE = curses.tparm(bgColorSeq, curses.COLOR_WHITE)
    BLACK = curses.tparm(bgColorSeq, curses.COLOR_BLACK)
    HIGH = curses.tigetstr("rev") or '['
    NORMAL = curses.tigetstr("sgr0") or ']'
    CHAR_COLOR_LEN = 0
else:
    BLUE = GREEN = CYAN = RED = MAGENTA = YELLOW = WHITE = BLACK = HIGH = '['
    NORMAL = ']'
    CHAR_COLOR_LEN = 1

