# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, String, Boolean, Text

from base import Base

class calendars_s(Base):
    __tablename__ = 'calendars_s'

    id          = Column(Integer, primary_key=True)
    parent      = Column(Integer)
    name        = Column(String(255))
    entry_type  = Column(Integer)    # 0 (calendar) or 1 (folder)
    description = Column(Text)
    formula     = Column(Text)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, parent, name, entry_type,
                 description, formula, workload_date):
        self.parent = parent
        self.name = name
        self.entry_type = entry_type
        self.description = description
        self.formula = formula
        self.workload_date = workload_date
