# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, ForeignKey

from base import Base

class job_host(Base):
    __tablename__ = 'job_host'

    job_id = Column(Integer, ForeignKey('job_main.id'), primary_key=True)
    host_id = Column(Integer, ForeignKey('hosts.id'))

    def __init__(self, host_id):
        self.host_id = host_id

    def copy(self):
        return job_host(self.host_id)
