Summary: A task scheduler
Name: schedwiclnt
Version: 0.1.4
Release: 1%{?dist}
License: GPL
Group: System Environment/Daemons
URL: http://www.nongnu.org/schedwi
Source: http://www.nongnu.org/schedwi/download/%{name}-%{version}.tar.gz
Requires: initscripts, gnutls >= 2.2.0, tcp_wrappers, libcgroup
BuildRequires: coreutils, sed, gnutls-devel >= 2.2.0, tcp_wrappers-devel, libcgroup-devel
BuildRoot: %{_tmppath}/%{name}-root


%description
Schedwi is a task scheduler.  It can run scripts or commands on remote agents
at a specified date and time and its chaining capability allows tasks to be
run in sequence.  Schedwi is composed of the following components:

* The server schedules the tasks and submits them to the agents.
  The execution of a task can be triggered by date and time but also by the
  result of a previous task or by the existence of a file on a remote agent
  (useful when a task must process a file generated by a previous task).

* The clients (or agents) receive the task requests from the server and
  run them on the local host.  They report the execution status to the server.

* An interface allows the administrators to follow the task scheduling in
  real time and to define new tasks.

This package (schedwiclnt) is the agent - or client - part of Schedwi.
It comes as a daemon and must be run on every computer of the network.


%prep
%setup -q


%build
CFLAGS="$RPM_OPT_FLAGS"; export CFLAGS
%ifarch ia64 x86_64 s390x ppc64
LDFLAGS="-L%{_libdir}"; export LDFLAGS
%endif
%configure --enable-ssl --with-certdir=/etc/pki/tls/certs --with-keydir=/etc/pki/tls/private
make


#%check
#echo ====================TESTING=========================
#make check
#echo ====================TESTING END=====================


%install
rm -rf ${RPM_BUILD_ROOT}
%makeinstall

%find_lang %{name}

install -d ${RPM_BUILD_ROOT}%{_initrddir}
install -m 755 scripts/schedwiclnt.redhat ${RPM_BUILD_ROOT}%{_initrddir}/schedwiclnt

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d
install -m 644 scripts/schedwiclnt.logrotate ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/schedwiclnt


%post
/sbin/chkconfig --add schedwiclnt


%preun
if [ $1 = 0 ]; then
   service schedwiclnt stop >/dev/null 2>&1
   /sbin/chkconfig --del schedwiclnt
   # remove status files
   rm -f %{_localstatedir}/run/schedwiclnt/results/*
fi


%clean
rm -rf ${RPM_BUILD_ROOT}


%files -f %{name}.lang
%defattr(-,root,root,-)
%doc	COPYING ChangeLog NEWS README*
%doc	doc/schedwi.xml doc/legal.xml doc/COPYING-DOCS doc/schedwi.html
%dir	%{_localstatedir}/run/schedwiclnt
%dir	%{_localstatedir}/run/schedwiclnt/results
%config(noreplace) %{_sysconfdir}/schedwiclnt.conf
%config(noreplace) %{_initrddir}/schedwiclnt
%config(noreplace) %{_sysconfdir}/logrotate.d/schedwiclnt
%{_bindir}/schedwiclnt
%{_mandir}/man5/*
%{_mandir}/man8/*


%changelog
* Thu Jan 24 2013 Herve Quatremain <rv4m@yahoo.co.uk>
- New schedwiclnt version (0.1.4)
* Tue Mar 23 2010 Herve Quatremain <rv4m@yahoo.co.uk>
- New schedwiclnt version (0.1.3)
* Wed Aug 22 2007 Herve Quatremain <rv4m@yahoo.co.uk>
- Package creation.
