/* Schedwi
   Copyright (C) 2007-2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * srvtest_reg.c -- Simulate the schedwireg daemon but always reply `ok' 
 *
 * Return:
 *   0 on success or
 *   an other return code for error
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#if HAVE_NETDB_H
#include <netdb.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifndef HAVE_RECV
#define recv(a,b,c,d) read(a,b,c)
#endif

#ifndef HAVE_SEND
#define send(a,b,c,d) write(a,b,c)
#endif

#ifndef PF_INET
#define PF_INET AF_INET
#endif

#ifndef HAVE_CLOSESOCKET
#define closesocket(x) close(x)
#endif


/*
 * memset - fill memory with a constant byte
 */
void *
schedwi_memset (void *s, int c, unsigned int n)
{
        char *tmp = s;

        if (s != 0) {
                while (n/10 != 0) {
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        n -= 10;
                }
                while (n > 0) {
                        *(tmp++) = c;
                        n--;
                }
        }
        return s;
}


/*
 * strlen - calculate the length of a string
 */
size_t
schedwi_strlen (const char *s)
{
	size_t i;

	if (s == NULL) {
		return 0;
	}
	for (i = 0; s[i] != '\0'; i++);
	return i;
}


/*
 * strncmp -- compare two strings
 */
int
schedwi_strncmp (const char *s1, const char *s2, unsigned int n)
{
	unsigned int i;

	if (s1 == 0) {
		if (s2 == 0) {
			return 0;
		}
		return -1;
	}
	if (s2 == 0) {
		return 1;
	}

	for (	i = 0;
		   i < n
		&& s1[i] != '\0' && s2[i] != '\0'
		&& s1[i] == s2[i];
		i++);
	return (i == n) ? 0 : s1[i] - s2[i];
}


/*
 * strnstr - locate a substring in the first n characters
 */
char *
schedwi_strnstr (char *haystack, const char *needle, unsigned int n)
{
	unsigned int len;

	if (needle == 0 || *needle == '\0' || haystack == 0) {
		return 0;
	}

	len = schedwi_strlen (needle);

	while (len <= n) {
		if (schedwi_strncmp (needle, haystack, len) == 0) {
			return haystack;
		}
		n--;
		haystack++;
	}

	return 0;
}


/*
 * atoi - convert a string to an integer (very simplified version)
 */
int
schedwi_atoi (const char *s)
{
	size_t i;
	int val;

	if (s == NULL) {
		return 0;
	}

	while (*s != '\0' && (*s == ' ' || *s == '\t')) {
		s++;
	}

	val = 0;
	for (i = 0; s[i] != '\0' && s[i] >= '0' && s[i] <= '9'; i++) {
		val *= 10;
		val += s[i] - '0';
	}
	return val;
}


/*
 * Main function
 */
int
main ()
{
	int sock, s, opt;
	struct sockaddr_in sad;
	ssize_t nb_read;
	char buff[4096], *str;


	/*
	 * Create the server socket (for the reply)
	 */

	/* Create the socket */
	sock = socket (PF_INET, SOCK_STREAM, 0);
	if (sock < 0) {
		return 2;
	}

	/* Set the REUSEADDR flag */
	opt = 1;
	setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof (opt));

	/* Compose the address */
	schedwi_memset (&sad, 0, sizeof(sad));
        sad.sin_family = AF_INET;
        sad.sin_addr.s_addr = htonl (INADDR_ANY);
	sad.sin_port = htons (schedwi_atoi (SCHEDWI_DEFAULT_REGPORT)); 

	/* Bind to the address */
	if (bind (sock, (struct sockaddr *)&sad, sizeof(sad)) != 0) {
		closesocket (sock);
		return 3;
	}

	/* Prepare to accept requests */
	if (listen (sock, 5) != 0) {
		closesocket (sock);
		return 4;
	}

	/* Wait for a request */
	s = accept (sock, NULL, NULL);
	if (s < 0) {
		closesocket (sock);
		return 6;
	}

	do {
		nb_read = recv (s, buff, 4096, 0);
		if (nb_read == 0) {
			break;
		}
		if (nb_read < 0) {
			closesocket (s);
			closesocket (sock);
			return 7;
		}
		if (schedwi_strnstr (buff, "]", nb_read) != NULL) {
			break;
		}
	} while (1);

	/* Send the reply */
	str = "{ \"success\" : true, \"data\" : \"ok\" }";
	send (s, str, schedwi_strlen (str), 0);
	closesocket (s);
	closesocket (sock);

	return 0;
}

/*------------------------======= End Of File =======------------------------*/
