/* Schedwi
   Copyright (C) 2013 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* control_groups_linux.h -- Associate a process to a Control Group */

#if HAVE_LIBCGROUP

#ifndef _CONTROL_GROUPS_LINUX_H
#define _CONTROL_GROUPS_LINUX_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

#if HAVE_PID_T
extern int cgroup_set OF((const char *cgroup_name, pid_t pid));
#else
extern int cgroup_set OF((const char *cgroup_name, int pid));
#endif

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* control_groups_linux.h */

#endif /* HAVE_LIBCGROUP */

/*-----------------============== End Of File ==============-----------------*/
