/* Copyright (C) 1993,97,2002 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <schedwi.h>

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#include <sys/cdefs.h>

#include <endian.h>

#ifndef HAVE_UINTXX_T
typedef u_int16_t uint16_t;
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#undef	htons

uint16_t
htons (x)
     uint16_t x;
{
#if BYTE_ORDER == LITTLE_ENDIAN
  return ((((x) >> 8) & 0xffu) | (((x) & 0xffu) << 8));
#else
  return x;
#endif
}
