# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to define a new cluster."""

import sys
import getopt

import sqlalchemy.exc

import set_options
from tables.clusters import clusters
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: mk [OPTION]... CLUSTER...
        Create new clusters."""))
    set_options.usage_options(with_clustername=False)


def mk(sql_session, arguments):
    """Create a new cluster.

    @param sql_session:
                SQLAlchemy session
    @param arguments:
                list of arguments given to the mk command (list of clustesr)
    @return:
                0 on success and 1 on error
    """
    # Parse the parameters
    try:
        optlist, args = set_options.parse_args(arguments)
    except getopt.GetoptError, err:
        sys.stderr.write(_("mk: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    if not args:
        sys.stderr.write(_("mk: missing the cluster name to create\n"))
        return 1
    session = sql_session.open_session()
    try:
        for a in args:
            cluster = clusters(a, '')
            session.add(cluster)
            if set_options.set(session, cluster, optlist) != 0:
                sql_session.cancel_session(session)
                return 1
        sql_session.close_session(session)
    except sqlalchemy.exc.IntegrityError:
        sql_session.cancel_session(session)
        sys.stderr.write(_("mk: a cluster with this name already exists\n"))
        return 1
    return 0
