# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module for readline auto-completion of workloads."""

from sqlalchemy import desc

from tables.job_status import job_status


def complete(sql_session, text):
    session = sql_session.open_session()
    q = session.query(job_status.workload_date)
    q = q.filter(job_status.job_id == 1)
    q = q.order_by(desc(job_status.workload_date))
    lst = [str(n) for n, in q.all()
           if str(n).startswith(text)]
    sql_session.close_session(session)
    if len(lst) == 1:
        return [lst[0] + ' ']
    return lst
