/* Schedwi
   Copyright (C) 2013 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* check_waiting_can_start.h -- Check if a waiting job/jobset can start */

#ifndef _CHECK_WAITING_CAN_START_H
#define _CHECK_WAITING_CAN_START_H

#include <schedwi.h>
#include <schedwi_time.h>
#include <schedwi_jobtree.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int check_waiting_can_start OF((	int workload_date,
				 	schedwi_jobtree_node_ptr ptr,
				 	schedwi_time current_time));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* check_waiting_can_start.h */

/*-----------------============== End Of File ==============-----------------*/
