/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_utils_glob.h -- Useful network functions */

#ifndef _NET_UTILS_GLOB_H
#define _NET_UTILS_GLOB_H

#include <schedwi.h>

#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#if HAVE_LIBGNUTLS
#include <gnutls/gnutls.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _net_id {
#if HAVE_LIBGNUTLS
	gnutls_session_t session;
#endif
	int sock;
	fd_set sock_set;
	int sock_max;
};
typedef struct _net_id net_id;

extern int net_server OF((	net_id *id, const char *port_number,
				const char *iface, const char *address_family));
extern int net_accept OF((	net_id *id, net_id *new_id,
				const char *schedwi_server_name,
				const char *allow_from));
extern int net_client OF((	net_id *id, const char *port_number,
				const char *hostname));
extern ssize_t net_read OF((net_id *id, char **buff, size_t *len));
extern int net_read_result OF((net_id *id, char **result_msg));
extern int net_write OF((net_id *id, const char *buff, size_t len));
extern int net_close OF((net_id *id));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_glob.h */

/*-----------------============== End Of File ==============-----------------*/
