#!/usr/bin/php
<?php
#     Copyright (C) 2005 Stewart Adam
#    This file is part of FWBackups.

#    FWBackups is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWBackups is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWBackups; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
$dir = `cat /etc/backup.conf.d/dir.conf`;
$drive = `cat /etc/backup.conf.d/drive.conf`;
$dir = trim("$dir");
$drive = trim("$drive");
# Mount
`mount $drive`;

# MOVE old backup first
`mv {$dir}/Backups/Linux {$dir}/Backups/Linux01`;
`mkdir {$dir}/Backups/Linux/`;

$file = file('/etc/backup.conf.d/paths.conf');

foreach($file as $key => $value)
{
if($key != "0")
{
$value = trim("$value");
`cp -a --parents $value {$dir}/Backups/Linux/`;
}
}
# etc into tar
`tar -cf {$dir}/Backups/Linux/etc.tar /etc/`;
# Save RPMS installed into a file
`rpm -qa > {$dir}/Backups/Linux/RPMS.txt`;
`rpm -qa --queryformat '%{NAME} ' > {$dir}/Backups/Linux/RPMS_for_yum.txt`;

# Print geometry info
`/sbin/fdisk -l > {$dir}/Backups/Linux/fdisk-l.txt`;

# Delete old backup, only if new one is completed
`rm -drf {$dir}/Backups/Linux01`;

#Chmod
`chmod 770 {$dir}/Backups/Linux/`;
?>
