#!/bin/bash
#    This file is part of FWBackups.

#    FWBackups is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWBackups is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWBackups; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
check=$(echo $USER)
if [ $check != "root" ]
then
echo "Install failed. Make sure you're root."
exit
fi
echo "Making Directories..."
mkdir /etc/backup.conf.d
echo "Copying backup script, backup.sh..."
cp -a ./files/cron.backup /etc/ -i
echo "Linking..."
cp ./files/etc/pam.d/* /etc/pam.d/ -i
cp ./files/etc/security/console.apps/* /etc/security/console.apps/ -i
cp -a ./files/backupconfig /usr/sbin -i
ln -s /etc/cron.backup/backup.sh /usr/sbin/
ln -s /usr/bin/consolehelper /usr/bin/backup.sh
chmod +x /usr/sbin/backup.sh
ln -s /usr/bin/consolehelper /usr/bin/backupconfig
echo "Adding Desktop Menu Entry..."
cp ./files/usr/share/applications/* /usr/share/applications/ -i
echo "Running backupconfig..."
/usr/bin/backupconfig
