#!/bin/bash
#     Copyright (C) 2005, 2006 Stewart Adam
#    This file is part of FWBackups.

#    FWaudio-convert-mod is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWaudio-convert-mod is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWaudio-convert-mod; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
if [ "$check" == "0" ]
	then
	ROOT_UID=0   # Root has $UID 0.
	# Checks to see if user is running as root
	if [ "$UID" != "$ROOT_UID" ];then
		echo "Install failed. Make sure you are root."
		exit 1
	fi
echo "Creating directories..."
mkdir /etc/FWBackups.conf.d
mkdir /usr/share/FWBackups
echo "Copying files..."
cp -a ./etc/FWbackups.conf.d/* /etc/FWBackups.conf.d
cp -a ./etc/pam.d/* /etc/pam.d
cp -a ./etc/security/console.apps/* /etc/security/console.apps/
cp -a ./usr/share/FWBackups/* /usr/share/FWBackups/
cp -a ./usr/share/applications/* /usr/share/applications/
echo "Symlinking..."
ln -s /usr/share/FWBackups/backupconfig.py /usr/sbin/backupconfig
ln -s /usr/share/FWBackups/backup.py /usr/sbin/runbackup
ln -s /usr/bin/consolehelper /usr/bin/runbackup
ln -s /usr/bin/consolehelper /usr/bin/backupconfig
