;; common.scm: Non-LALR parser implementation for SCSS
;; Copyright (C) 2010 Julian Graham

;; SCSS is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

#!r6rs

(library (scss common)
  (export replace-escapes symbol-downcase pseudo-classes pseudo-elements
	  parse-attrib-str)
  (import (rnrs) (only (srfi :1) list-index take))

  (define pseudo-classes
    '("first-child" "link" "visited" "hover" "active" "focus" "lang"))
  
  (define pseudo-elements '("first-line" "first-letter" "before" "after"))

  (define (replace-escapes s)
    (define (list->char lst)
      (let ((n (string->number (list->string lst) 16)))      
	(list (integer->char n))))

  ;; TODO: Tidy this up...

    (define (f l esc ws cs)
      (let ((c (and (not (null? l)) (car l))))
	(cond ((not c) (if (null? cs) '() (list->char cs)))
	      ((and (char-whitespace? c) (not (null? cs))) (f (cdr l) #f #t cs))
	      ((= (length cs) 6) (append (list->char cs) (f l #f #f '())))
	      (ws (if (char-whitespace? c) 
		      (f (cdr l) #f #t cs)
		      (append (list->char cs) (f l #f #f '()))))
	      ((or (char-numeric? c) (and (char-ci>=? c #\a) 
					  (char-ci<=? c #\f)))
	       (cond (esc (f (cdr l) #f #f `(,c)))
		     ((null? cs) (append `(,c) (f (cdr l) #f #f '())))
		     (else (f (cdr l) #f #f (append cs `(,c))))))
	      ((eqv? c #\\) (if esc
				(append (list #\\) (f (cdr l) #f #f '()))
				(if (null? cs) 
				    (f (cdr l) #t #f '())
				    (append (list->char cs)
					    (f (cdr l) #t #f '())))))
	      (else (cond (esc (append (list (if (char-whitespace? c) 
						 #\space c))
				       (f (cdr l) #f #f '())))
			  ((null? cs) (append `(,c) (f (cdr l) #f #f '())))
			  (else (append (list->char cs)
					`(,c) (f (cdr l) #f #f '()))))))))

    (if (symbol? s)
	(string->symbol 
	 (list->string 
	  (f (string->list (symbol->string s)) #f #f '())))
	(list->string (f (string->list s) #f #f '()))))

  (define (symbol-downcase x)
    (string->symbol (string-downcase (symbol->string x))))

  (define (parse-attrib-str str)
    (define (quote-pred x) (or (eqv? #\" x) (eqv? #\' x)))
    (define (tilde-pred x) (eqv? #\~ x))
    (define (pipe-pred x) (eqv? #\x007c x))
    (define (equal-pred x) (eqv? #\= x))
    
    (let* ((chrs (string->list str))
	   (quot (list-index quote-pred chrs))
	   (p (list-index tilde-pred chrs))
	   (p (or (and p (or (not quot) (< p quot)) p)
		  (list-index pipe-pred chrs)))
	   (p (or (and p (or (not quot) (< p quot)) p)
		  (list-index equal-pred chrs))))
      (if p
	  (list (case (list-ref chrs p) 
		  ((#\~) '~=) 
		  ((#\x007c) (string->symbol "|=")) 
		  ((#\=) '=))
		(string->symbol (list->string (take (cdr chrs) (- p 1)))) 
		(let* ((ccs (cdr chrs))
		       (val (list-tail ccs (if (eqv? (list-ref chrs p) #\=) 
					       p 
					       (+ p 1)))))
		  (list->string (take (if quot (cdr val) val) 
				      (- (length val) (if quot 3 1))))))
	  (string->symbol 
	   (list->string (take (cdr chrs) (- (length chrs) 2)))))))
)
