;; -*- Scheme -*-
;;; sdcdc.scm --- Top part common to the other scripts.

;; Copyright (C)  2002,2003,2011  Marco Parrone.

;; Author: Marco Parrone
;; Maintainer: Marco Parrone <marco@marcoparrone.com>
;; Keywords: gimp script debian cdrom cover
;; Language: Scheme (The GIMP's Script-Fu)

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Commentary:

;; This is a part of sdcdc (some Debian CD's covers), a generator for
;; Debian CD's labels and front covers.

;;; Code:

;; This function returns the visibility of the given layer (layer-name)
;; in a list of pairs of layers-names and visibility values.
;; It returns 0 if the layer is invisible, 1 if it is visible,
;; nil if it does not exists.
(define get-visibility
  (lambda (layer-name active-layers-map)
    (cadr (member layer-name active-layers-map))))

;; This function is used only by set-layers-visibility,
;; and pratically is part of it.
(define set-layers-visibility-helper
  (lambda (layers active-layers-map clayer)
    (if (= (get-visibility	
	    (car (gimp-layer-get-name (+ clayer 2))) active-layers-map)
	   1)
	(gimp-layer-set-visible
	 (+ clayer 2)
	 (get-visibility
	  (car (gimp-layer-get-name (+ clayer 2))) active-layers-map)))
    (if (< clayer (- (car layers) 1))
	(set-layers-visibility-helper layers active-layers-map (+ clayer 1)))))

;; Sets the visibility of the layers in "layers" according
;; to the map of visible layers "active-layers-map".
(define set-layers-visibility
  (lambda (layers active-layers-map)
    (set-layers-visibility-helper layers active-layers-map 0)))

;; The map of the visible layers.
(define active-layers-map '("CD Background" 0
			    "Front-cover background" 0
			    "Logo" 1
			    "Web site" 1
			    "System gnu-linux" 0
			    "System gnu-hurd" 0
			    "System gnu-netbsd" 0
			    "System gnu-kfreebsd" 0
			    "Version 6.0.0" 0
			    "Version 6.0.1" 0
			    "Version potato" 0
			    "Version woody" 0
			    "Version sarge" 0
			    "Version etch" 0
			    "Version lenny" 0
			    "Version squeeze" 0
			    "Version sid" 0
			    "Version label [en]" 0
			    "Version label [it]" 0
			    "Architecture [i386-en]" 0
			    "Architecture [m68k-en]" 0
			    "Architecture [sparc-en]" 0
			    "Architecture [alpha-en]" 0
			    "Architecture [powerpc-en]" 0
			    "Architecture [arm-en]" 0
			    "Architecture [mips-en]" 0
			    "Architecture [mipsel-en]" 0
			    "Architecture [hppa-en]" 0
			    "Architecture [ia64-en]" 0
			    "Architecture [s390-en]" 0
			    "Architecture [armel-en]" 0
			    "Architecture [amd64-en]" 0
			    "Architecture [ppc64-en]" 0
			    "Architecture [superh-en]" 0
			    "Architecture [armhf-en]" 0
			    "Architecture [m32r-en]" 0
			    "Architecture [avr32-en]" 0
			    "Architecture [i386-it]" 0
			    "Architecture [m68k-it]" 0
			    "Architecture [sparc-it]" 0
			    "Architecture [alpha-it]" 0
			    "Architecture [powerpc-it]" 0
			    "Architecture [arm-it]" 0
			    "Architecture [mips-it]" 0
			    "Architecture [mipsel-it]" 0
			    "Architecture [hppa-it]" 0
			    "Architecture [ia64-it]" 0
			    "Architecture [s390-it]" 0
			    "Architecture [armel-it]" 0
			    "Architecture [amd64-it]" 0
			    "Architecture [ppc64-it]" 0
			    "Architecture [superh-it]" 0
			    "Architecture [armhf-it]" 0
			    "Architecture [m32r-it]" 0
			    "Architecture [avr32-it]" 0
			    "Common CD number [en]" 0
			    "Common DVD number [en]" 0
			    "Common BD number [en]" 0
			    "Common CD number [it]" 0
			    "Common DVD number [it]" 0
			    "Common BD number [it]" 0
			    "CD 0" 0
			    "CD 1" 0
			    "CD 2" 0
			    "CD 3" 0
			    "CD 4" 0
			    "CD 5" 0
			    "CD 6" 0
			    "CD 7" 0
			    "CD 8" 0
			    "CD 9" 0
			    "CD 10" 0
			    "CD 20" 0
			    "CD 30" 0
			    "CD 40" 0
			    "CD 50" 0
			    "CD 60" 0
			    "CD 70" 0
			    "CD 80" 0
			    "CD 90" 0
			    "Swirl" 1))

;; Sets the background (that for the CDs or that for the front covers.
(define sdcdc-set-helper-cd-or-fc
  (lambda (cd-or-fc)
    (set-car!
     (cdr (member (if (or (= cd-or-fc 2)
			  (= cd-or-fc 5)
			  (= cd-or-fc 6))
		      "Front-cover background"
		      "CD Background" )
		  active-layers-map))
     1)))

;; Sets the system.
(define sdcdc-set-helper-system
  (lambda (system)
    (if (= system 1)
	(set-car! (cdr (member "System gnu-linux" active-layers-map)) 1))
    (if (= system 2)
	(set-car! (cdr (member "System gnu-hurd" active-layers-map)) 1))
    (if (= system 3)
	(set-car! (cdr (member "System gnu-netbsd" active-layers-map)) 1))
    (if (= system 4)
	(set-car! (cdr (member "System gnu-kfreebsd" active-layers-map)) 1))))

;; Sets the version.
(define sdcdc-set-helper-vers
  (lambda (vers)
    (if (= vers 1)
	(set-car! (cdr (member "Version 6.0.0" active-layers-map)) 1))
    (if (= vers 2)
	(set-car! (cdr (member "Version 6.0.1" active-layers-map)) 1))
    (if (= vers 3)
	(set-car! (cdr (member "Version potato" active-layers-map)) 1))
    (if (= vers 4)
	(set-car! (cdr (member "Version woody" active-layers-map)) 1))
    (if (= vers 5)
	(set-car! (cdr (member "Version sid" active-layers-map)) 1))
    (if (= vers 6)
	(set-car! (cdr (member "Version sarge" active-layers-map)) 1))
    (if (= vers 7)
	(set-car! (cdr (member "Version etch" active-layers-map)) 1))
    (if (= vers 8)
	(set-car! (cdr (member "Version lenny" active-layers-map)) 1))
    (if (= vers 9)
	(set-car! (cdr (member "Version squeeze" active-layers-map)) 1))))

(define sdcdc-set-helper-cd-number-helper
  (lambda (tens cd-number)
    (let ((tmp (- cd-number tens)))
      (if (= tmp 0)
	  (set-car! (cdr (member "CD 0" active-layers-map)) 1))
      (if (= tmp 1)
	  (set-car! (cdr (member "CD 1" active-layers-map)) 1))
      (if (= tmp 2)
	  (set-car! (cdr (member "CD 2" active-layers-map)) 1))
      (if (= tmp 3)
	  (set-car! (cdr (member "CD 3" active-layers-map)) 1))
      (if (= tmp 4)
	  (set-car! (cdr (member "CD 4" active-layers-map)) 1))
      (if (= tmp 5)
	  (set-car! (cdr (member "CD 5" active-layers-map)) 1))
      (if (= tmp 6)
	  (set-car! (cdr (member "CD 6" active-layers-map)) 1))
      (if (= tmp 7)
	  (set-car! (cdr (member "CD 7" active-layers-map)) 1))
      (if (= tmp 8)
	  (set-car! (cdr (member "CD 8" active-layers-map)) 1))
      (if (= tmp 9)
	  (set-car! (cdr (member "CD 9" active-layers-map)) 1)))))

;; Sets the CD number.
(define sdcdc-set-helper-cd-number
  (lambda (cd-number)
    (if (> cd-number 89)
	(begin
	  (sdcdc-set-helper-cd-number-helper 90 cd-number)
	  (set-car! (cdr (member "CD 90" active-layers-map)) 1))
	(if (> cd-number 79)
	    (begin
	      (sdcdc-set-helper-cd-number-helper 80 cd-number)
	      (set-car! (cdr (member "CD 80" active-layers-map)) 1))
	    (if (> cd-number 69)
		(begin
		  (sdcdc-set-helper-cd-number-helper 70 cd-number)
		  (set-car! (cdr (member "CD 70" active-layers-map)) 1))
		(if (> cd-number 59)
		    (begin
		      (sdcdc-set-helper-cd-number-helper 60 cd-number)
		      (set-car! (cdr (member "CD 60" active-layers-map)) 1))
		    (if (> cd-number 49)
			(begin
			  (sdcdc-set-helper-cd-number-helper 50 cd-number)
			  (set-car! (cdr (member "CD 50" active-layers-map)) 1))
			(if (> cd-number 39)
			    (begin
			      (sdcdc-set-helper-cd-number-helper 40 cd-number)
			      (set-car!
			       (cdr (member "CD 40" active-layers-map)) 1))
			    (if (> cd-number 29)
				(begin
				  (sdcdc-set-helper-cd-number-helper 30
								     cd-number)
				  (set-car!
				   (cdr (member "CD 30" active-layers-map)) 1))
				(if (> cd-number 19)
				    (begin
				      (sdcdc-set-helper-cd-number-helper
				       20 cd-number)
				      (set-car!
				       (cdr (member "CD 20" active-layers-map))
				       1))
				    (if (> cd-number 9)
					(begin
					  (sdcdc-set-helper-cd-number-helper
					   10 cd-number)
					  (set-car!
					   (cdr
					    (member "CD 10" active-layers-map))
					   1))
					(sdcdc-set-helper-cd-number-helper
					 0 cd-number))))))))))))

;; Sets the common CD number.
(define sdcdc-set-helper-common-cd-number
  (lambda (lang cd-or-fc)
    (set-car! 
     (cdr
      (member 
       (if (= lang 1)
	   (if (or (= cd-or-fc 1) (= cd-or-fc 2))
	       "Common CD number [en]"
	       (if (or (= cd-or-fc 3) (= cd-or-fc 5))
		   "Common DVD number [en]"
		   (if (or (= cd-or-fc 4) (= cd-or-fc 6))
		       "Common BD number [en]"
		       "not a CD nor a DVD nor a BD")))
	   (if (or (= cd-or-fc 1) (= cd-or-fc 2))
	       "Common CD number [it]"
	       (if (or (= cd-or-fc 3) (= cd-or-fc 5))
		   "Common DVD number [it]"
		   (if (or (= cd-or-fc 4) (= cd-or-fc 6))
		       "Common BD number [it]"
		       "not a CD nor a DVD nor a BD"))))
       active-layers-map)) 1)))

;; Sets the version label.
(define sdcdc-set-helper-version-label
  (lambda (lang)
    (if (= lang 1)
	(set-car! (cdr (member "Version label [en]" active-layers-map)) 1))
    (if (= lang 2)
	(set-car! (cdr (member "Version label [it]" active-layers-map)) 1))))

;; Sets the arch (1st part).
(define sdcdc-set-helper-arch-1
  (lambda (arch lang)
    (if (and (= lang 1) (= arch 1))
	(set-car!
	 (cdr (member "Architecture [i386-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 2))
	(set-car!
	 (cdr (member "Architecture [m68k-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 3))
	(set-car!
	 (cdr (member "Architecture [sparc-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 4))
	(set-car!
	 (cdr (member "Architecture [alpha-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 5))
	(set-car!
	 (cdr (member "Architecture [powerpc-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 6))
	(set-car!
	 (cdr (member "Architecture [arm-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 7))
	(set-car!
	 (cdr (member "Architecture [mips-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 8))
	(set-car!
	 (cdr (member "Architecture [mipsel-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 9))
	(set-car!
	 (cdr (member "Architecture [hppa-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 10))
	(set-car!
	 (cdr (member "Architecture [ia64-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 11))
	(set-car!
	 (cdr (member "Architecture [s390-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 12))
	(set-car!
	 (cdr (member "Architecture [armel-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 13))
	(set-car!
	 (cdr (member "Architecture [amd64-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 14))
	(set-car!
	 (cdr (member "Architecture [ppc64-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 15))
	(set-car!
	 (cdr (member "Architecture [superh-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 16))
	(set-car!
	 (cdr (member "Architecture [armhf-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 17))
	(set-car!
	 (cdr (member "Architecture [m32r-en]" active-layers-map)) 1))
    (if (and (= lang 1) (= arch 18))
	(set-car!
	 (cdr (member "Architecture [avr32-en]" active-layers-map)) 1))))

;; Sets the arch (2nd part).
(define sdcdc-set-helper-arch-2
  (lambda (arch lang)
    (if (and (= lang 2) (= arch 1))
	(set-car! (cdr (member "Architecture [i386-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 2))
	(set-car! (cdr (member "Architecture [m68k-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 3))
	(set-car!
	 (cdr (member "Architecture [sparc-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 4))
	(set-car!
	 (cdr (member "Architecture [alpha-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 5))
	(set-car!
	 (cdr (member "Architecture [powerpc-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 6))
	(set-car! (cdr (member "Architecture [arm-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 7))
	(set-car! (cdr (member "Architecture [mips-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 8))
	(set-car!
	 (cdr (member "Architecture [mipsel-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 9))
	(set-car! (cdr (member "Architecture [hppa-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 10))
	(set-car! (cdr (member "Architecture [ia64-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 11))
	(set-car!
	 (cdr (member "Architecture [s390-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 12))
	(set-car!
	 (cdr (member "Architecture [armel-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 13))
	(set-car!
	 (cdr (member "Architecture [amd64-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 14))
	(set-car!
	 (cdr (member "Architecture [ppc64-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 15))
	(set-car!
	 (cdr (member "Architecture [superh-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 16))
	(set-car!
	 (cdr (member "Architecture [armhf-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 17))
	(set-car!
	 (cdr (member "Architecture [m32r-it]" active-layers-map)) 1))
    (if (and (= lang 2) (= arch 18))
	(set-car!
	 (cdr (member "Architecture [avr32-it]" active-layers-map)) 1))))

;; This selects the layers to make visible.
;; This is to be changed when new layers are added.
(define sdcdc-set
  (lambda (cd-or-fc cd-number lang arch system vers)
    (sdcdc-set-helper-cd-or-fc cd-or-fc)
    (sdcdc-set-helper-system system)
    (sdcdc-set-helper-vers vers)
    (sdcdc-set-helper-cd-number cd-number)
    (sdcdc-set-helper-common-cd-number lang cd-or-fc)
    (sdcdc-set-helper-version-label lang)
    (sdcdc-set-helper-arch-1 arch lang)
    (sdcdc-set-helper-arch-2 arch lang)))

;; The output file.
(define outfile '())

;; The current image.
(define cimage '())

;; The layers.
(define layers '())

;; Current drawable.
(define cdrawable '())

;; Does the work (selects the layers, flats the image, saves
;; the output image.
(define sdcdc-action
  (lambda (filename src-image cd-or-fc cd-number lang arch system vers)
    (set! outfile filename)
    (set! cimage (gimp-xcf-load 1 src-image src-image))
    (set! layers (gimp-image-get-layers (car cimage)))
    (sdcdc-set cd-or-fc cd-number lang arch system vers)
    (set-layers-visibility layers active-layers-map)
    (set! cdrawable (gimp-image-flatten (car cimage)))
    (file-jpeg-save 1 (car cimage) (car cdrawable)
		    outfile outfile 0.80 0.80 1 1 "Made with sdcdc (using the GIMP)." 0 0 0 1)))

;;; sdcdc.scm ends here.
