;; common.scm: common code for SDOM
;; Copyright (C) 2011 Julian Graham

;; SDOM free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; SDOM is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SDOM.  If not, see <http://www.gnu.org/licenses/>.

#!r6rs

(library (sdom common (0 5 1))
  (export xml-ns-uri ncname?)
  (import (rnrs) (only (srfi :1) every))

  (define (ncname-start-char? c) 
    (memq (char-general-category c) '(Ll Lu Lo Lt Nl)))

  (define (ncname-char? c)
    (or (ncname-start-char? c) 
	(memq (char-general-category c) '(Mc Me Mn Lm Nd))))
  
  (define (ncname? n) 
    (let ((lst (string->list n)))
      (and (not (null? lst))
	   (ncname-start-char? (car lst))
	   (every ncname-char? (cdr lst)))))

  (define xml-ns-uri "http://www.w3.org/XML/1998/namespace")
)