/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl;

import java.util.Vector;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.altrmi.common.AbstractMethodHandler;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.server.AltrmiAuthenticator;
import org.apache.excalibur.altrmi.server.AltrmiServer;
import org.apache.excalibur.altrmi.server.AltrmiServerConnection;
import org.apache.excalibur.altrmi.server.AltrmiServerException;
import org.apache.excalibur.altrmi.server.ClassRetriever;
import org.apache.excalibur.altrmi.server.MethodInvocationHandler;
import org.apache.excalibur.altrmi.server.PublicationDescription;
import org.apache.excalibur.altrmi.server.PublicationException;
import org.apache.excalibur.altrmi.server.impl.adapters.InvocationHandlerAdapter;

public abstract class AbstractServer
extends AbstractMethodHandler
implements AltrmiServer,
LogEnabled {
    private Vector mConnections = new Vector();
    protected InvocationHandlerAdapter mInovcationHandlerAdapter;
    private Logger mLogger;
    protected static final int SHUTTINGDOWN = 11;
    protected static final int STARTED = 22;
    protected static final int STOPPED = 33;
    protected static final int UNSTARTED = 44;
    protected int mState = 44;

    public AbstractServer() {
        this.mInovcationHandlerAdapter = new InvocationHandlerAdapter();
    }

    public AbstractServer(InvocationHandlerAdapter inovcationHandlerAdapter) {
        this.mInovcationHandlerAdapter = inovcationHandlerAdapter;
    }

    public void enableLogging(Logger logger) {
        this.mLogger = logger;
    }

    public synchronized Logger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = new ConsoleLogger();
        }
        return this.mLogger;
    }

    public final void setClassRetriever(ClassRetriever classRetriever) {
        this.mInovcationHandlerAdapter.setClassRetriever(classRetriever);
    }

    public final void setAuthenticator(AltrmiAuthenticator altrmiAuthenticator) {
        this.mInovcationHandlerAdapter.setAuthenticator(altrmiAuthenticator);
    }

    public AltrmiReply handleInvocation(AltrmiRequest request) {
        return this.mInovcationHandlerAdapter.handleInvocation(request);
    }

    public void suspend() {
        this.mInovcationHandlerAdapter.suspend();
    }

    public void resume() {
        this.mInovcationHandlerAdapter.resume();
    }

    protected void connectionStart(AltrmiServerConnection altrmiConnection) {
        this.mConnections.add(altrmiConnection);
    }

    protected void connectionCompleted(AltrmiServerConnection altrmiConnection) {
        this.mConnections.remove(altrmiConnection);
    }

    protected void killAllConnections() {
        AltrmiServerConnection[] connections = this.mConnections.toArray(new AltrmiServerConnection[0]);
        int i = 0;
        while (i < connections.length) {
            connections[i].endConnection();
            ++i;
        }
    }

    public void publish(Object impl, String asName, Class interfaceToExpose) throws PublicationException {
        this.mInovcationHandlerAdapter.publish(impl, asName, interfaceToExpose);
    }

    public void publish(Object impl, String asName, PublicationDescription publicationDescription) throws PublicationException {
        this.mInovcationHandlerAdapter.publish(impl, asName, publicationDescription);
    }

    public void unPublish(Object impl, String asName) throws PublicationException {
        this.mInovcationHandlerAdapter.unPublish(impl, asName);
    }

    public void replacePublished(Object oldImpl, String asName, Object withImpl) throws PublicationException {
        this.mInovcationHandlerAdapter.replacePublished(oldImpl, asName, withImpl);
    }

    public MethodInvocationHandler getMethodInvocationHandler(MethodRequest mr, String objectName) {
        return this.mInovcationHandlerAdapter.getMethodInvocationHandler(mr, objectName);
    }

    public MethodInvocationHandler getMethodInvocationHandler(String publishedName) {
        return this.mInovcationHandlerAdapter.getMethodInvocationHandler(publishedName);
    }

    public abstract void stop();

    public abstract void start() throws AltrmiServerException;
}

