/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.adapters;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.excalibur.altrmi.common.AbstractMethodHandler;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.server.AltrmiPublisher;
import org.apache.excalibur.altrmi.server.MethodInvocationHandler;
import org.apache.excalibur.altrmi.server.PublicationDescription;
import org.apache.excalibur.altrmi.server.PublicationException;
import org.apache.excalibur.altrmi.server.impl.DefaultMethodInvocationHandler;

public class PublicationAdapter
extends AbstractMethodHandler
implements AltrmiPublisher {
    protected HashMap mPublishedObjects = new HashMap();

    public void publish(Object impl, String asName, Class interfaceToExpose) throws PublicationException {
        this.publish(impl, asName, new PublicationDescription(new Class[]{interfaceToExpose}, new Class[0]));
    }

    public void publish(Object impl, String asName, PublicationDescription publicationDescription) throws PublicationException {
        Class[] interfacesToExpose = publicationDescription.getInterfacesToExpose();
        Class[] additionalFacades = publicationDescription.getAdditionalFacades();
        if (this.mPublishedObjects.containsKey(asName + "_Main")) {
            throw new PublicationException("Service '" + asName + "' already published");
        }
        String[] interfaceNames = new String[interfacesToExpose.length];
        int i = 0;
        while (i < interfacesToExpose.length) {
            interfaceNames[i] = interfacesToExpose[i].getName();
            ++i;
        }
        HashMap<String, Method> mainMethodMap = new HashMap<String, Method>();
        DefaultMethodInvocationHandler mainMethodInvocationHandler = new DefaultMethodInvocationHandler(this, asName + "_Main", mainMethodMap, publicationDescription);
        mainMethodInvocationHandler.addImplementationBean(new Long(0L), impl);
        int x = 0;
        while (x < interfacesToExpose.length) {
            Method[] methods = interfacesToExpose[x].getMethods();
            int y = 0;
            while (y < methods.length) {
                Method method = methods[y];
                String methodSignature = this.getMethodSignature(method);
                if (!mainMethodMap.containsKey(methodSignature.toString())) {
                    mainMethodMap.put(methodSignature.toString(), methods[y]);
                }
                ++y;
            }
            ++x;
        }
        this.mPublishedObjects.put(asName + "_Main", mainMethodInvocationHandler);
        int x2 = 0;
        while (x2 < additionalFacades.length) {
            Method[] methods = additionalFacades[x2].getMethods();
            String encodedClassName = this.encodeClassName(additionalFacades[x2].getName());
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            DefaultMethodInvocationHandler methodInvocationHandler = new DefaultMethodInvocationHandler(this, asName + "_" + encodedClassName, methodMap, publicationDescription);
            int y = 0;
            while (y < methods.length) {
                Method method = methods[y];
                String methodSignature = this.getMethodSignature(method);
                if (!methodMap.containsKey(methodSignature.toString())) {
                    methodMap.put(methodSignature.toString(), methods[y]);
                }
                ++y;
            }
            this.mPublishedObjects.put(asName + "_" + encodedClassName, methodInvocationHandler);
            ++x2;
        }
    }

    public void unPublish(Object impl, String asName) throws PublicationException {
        if (!this.mPublishedObjects.containsKey(asName + "_Main")) {
            throw new PublicationException("Service '" + asName + "' not published");
        }
        this.mPublishedObjects.remove(asName + "_Main");
    }

    public void replacePublished(Object oldImpl, String asName, Object withImpl) throws PublicationException {
        if (!this.mPublishedObjects.containsKey(asName + "_Main")) {
            throw new PublicationException("Service '" + asName + "' not published");
        }
        MethodInvocationHandler asih = (MethodInvocationHandler)this.mPublishedObjects.get(asName + "_Main");
        asih.replaceImplementationBean(oldImpl, withImpl);
    }

    public MethodInvocationHandler getMethodInvocationHandler(MethodRequest mr, String objectName) {
        return (MethodInvocationHandler)this.mPublishedObjects.get(mr.getPublishedServiceName() + "_" + objectName);
    }

    public MethodInvocationHandler getMethodInvocationHandler(String publishedName) {
        return (MethodInvocationHandler)this.mPublishedObjects.get(publishedName);
    }
}

