/*
 * Decompiled with CFR 0.152.
 */
package uk.co.weft.maybeupload;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.weft.maybeupload.MaybeUploadRequestWrapper;

public abstract class MaybeUploadServlet
extends HttpServlet {
    protected String uploadDirPath = "/tmp";
    protected String uploadDirURL = null;
    protected boolean allowOverwrite = false;
    protected boolean silentlyRename = true;
    protected int maxUpload = 524288;
    protected File uploadDir;
    protected boolean saveUploadedFilesToDisk = true;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";

    protected void doDelete(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doDelete((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doGet(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doGet((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doHead(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = maybeUploadRequestWrapper.getProtocol();
        String string2 = "HTTP method HEAD not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doOptions(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doOptions((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doPost(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doPost((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doPut(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doPut((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doTrace(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doTrace((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    private boolean getBooleanParameterValue(String string, ServletConfig servletConfig, boolean bl) {
        boolean bl2 = bl;
        String string2 = servletConfig.getServletContext().getInitParameter(string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        if ((string2 = servletConfig.getInitParameter(string)) != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    private int getIntParameterValue(String string, ServletConfig servletConfig, int n) {
        int n2 = n;
        String string2 = servletConfig.getServletContext().getInitParameter(string);
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if ((string2 = servletConfig.getInitParameter(string)) != null) {
            n2 = Integer.parseInt(string2);
        }
        return n2;
    }

    private String getStringParameterValue(String string, ServletConfig servletConfig, String string2) {
        String string3 = string2;
        String string4 = servletConfig.getServletContext().getInitParameter(string);
        if (string4 != null) {
            string3 = string4;
        }
        if ((string4 = servletConfig.getInitParameter(string)) != null) {
            string3 = string4;
        }
        return string3;
    }

    public File getUploadDir() {
        return this.uploadDir;
    }

    public String getUploadURL() {
        return this.uploadDirURL;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.uploadDirPath = this.getStringParameterValue("upload_dir_path", servletConfig, this.uploadDirPath);
        this.uploadDirURL = this.getStringParameterValue("upload_dir_url", servletConfig, this.uploadDirURL);
        this.allowOverwrite = this.getBooleanParameterValue("allow_overwrite", servletConfig, this.allowOverwrite);
        this.silentlyRename = this.getBooleanParameterValue("silently_rename", servletConfig, this.silentlyRename);
        this.saveUploadedFilesToDisk = this.getBooleanParameterValue("save_uploaded", servletConfig, this.saveUploadedFilesToDisk);
        this.maxUpload = this.getIntParameterValue("max_upload", servletConfig, this.maxUpload);
        this.uploadDir = new File(this.uploadDirPath);
        if (!this.uploadDir.isDirectory() || !this.uploadDir.canWrite()) {
            throw new UnavailableException("Cannot write to upload directory " + this.uploadDirPath);
        }
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        MaybeUploadRequestWrapper maybeUploadRequestWrapper = new MaybeUploadRequestWrapper(httpServletRequest, this.saveUploadedFilesToDisk, this.uploadDir, this.allowOverwrite, this.silentlyRename, this.maxUpload);
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(maybeUploadRequestWrapper, httpServletResponse);
            } else {
                long l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, l);
                    this.doGet(maybeUploadRequestWrapper, httpServletResponse);
                } else {
                    httpServletResponse.setStatus(304);
                }
            }
        } else if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(maybeUploadRequestWrapper, httpServletResponse);
        } else {
            httpServletResponse.sendError(501, new String("HTTP Method [" + string + "] is not implemented"));
        }
    }
}

