/*
 * Decompiled with CFR 0.152.
 */
package uk.co.weft.maybeupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import uk.co.weft.maybeupload.EndOfPartException;
import uk.co.weft.maybeupload.UploadException;

public class MultipartHandler {
    private boolean saveUploadedFilesToDisk = true;
    private boolean allowOverwrite = false;
    private boolean silentlyRename = true;
    private Stack boundaries = new Stack();
    protected Hashtable values = null;
    private PushbackInputStream in;
    private int expected;
    private File workDir;
    private int read = 0;
    private byte[] buf = new byte[8192];
    private int validChars = 0;
    protected int anon = 0;
    protected final boolean DEBUG = true;
    protected final char CTE_7BIT = (char)55;
    protected final char CTE_QUOTED_PRINTABLE = (char)113;
    protected final char CTE_BASE64 = (char)97;
    protected final char CTE_8BIT = (char)56;
    protected final char CTE_BINARY = (char)105;
    protected final char CTE_XTOKEN = (char)120;
    private final String filePattern = "form-data; *name=\"([^\"]*)\"; *filename=\"([^\"]*)\"";
    private final String simplePattern = "form-data; *name=\"([^\"]*)\"";
    protected Hashtable disallowedCharacters = new Hashtable();

    MultipartHandler(Hashtable hashtable, InputStream inputStream, int n, String string, File file) throws IOException, UploadException {
        this(hashtable, inputStream, n, string, file, true, false, true);
    }

    MultipartHandler(Hashtable hashtable, InputStream inputStream, int n, String string, File file, boolean bl, boolean bl2, boolean bl3) throws IOException, UploadException {
        this.in = new PushbackInputStream(inputStream);
        this.expected = n;
        this.saveUploadedFilesToDisk = bl;
        this.workDir = file;
        this.values = hashtable;
        this.allowOverwrite = bl2;
        this.silentlyRename = bl3;
        this.disallow(' ', '_');
        this.disallow("?*", '_');
        this.disallow('#', '_');
        System.out.println("\n\n*** starting to read input");
        this.readrfc1867(string);
        System.out.println("\n*** finished reading input");
        System.out.println("internal count shows: read " + this.read + " of expected " + this.expected + " bytes\n");
    }

    private String deString(String string) {
        if (string != null) {
            string = string.trim();
            while (string.startsWith("\"")) {
                string = string.substring(1);
            }
            while (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public void disallow(char c, char c2) {
        this.disallowedCharacters.put(new Character(c), new Character(c2));
    }

    public void disallow(String string, char c) {
        int n = 0;
        while (n < string.length()) {
            this.disallow(string.charAt(n), c);
            ++n;
        }
    }

    private void extractPartHeadersFromLine(String string, Hashtable hashtable) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = ":";
        String string5 = ";";
        while (n2 < string.length()) {
            n2 = string.indexOf(string4, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            string2 = this.deString(string.substring(n, n2));
            string4 = "=";
            n = n2 + 1;
            if ((n2 = string.indexOf(string5, n)) == -1) {
                n2 = string.length();
            }
            string3 = this.deString(string.substring(n, n2));
            n = n2 + 1;
            System.out.println("  ++ Setting part header [" + string2 + "] to [" + string3 + "]");
            hashtable.put(string2, string3);
        }
    }

    private final String getBoundary(String string) {
        int n = string.indexOf("boundary=");
        String string2 = null;
        if (n > -1) {
            string2 = "--" + string.substring(n + 9);
        }
        return string2;
    }

    protected String handleFilePart(Hashtable hashtable, char c, String string) throws IOException, UploadException {
        Object object;
        String string2 = null;
        String string3 = (String)hashtable.get("filename");
        File file = null;
        if (string3 != null) {
            int n = Math.max(string3.lastIndexOf(47), string3.lastIndexOf("\\"));
            System.out.println("Seeking separator in filename [" + string3 + "]; index was " + n);
            if (n > -1) {
                string3 = string3.substring(n + 1);
            }
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "unknown" + new Integer(this.anon++).toString();
        }
        Enumeration enumeration = this.disallowedCharacters.keys();
        while (enumeration.hasMoreElements()) {
            object = (Character)enumeration.nextElement();
            Character c2 = (Character)this.disallowedCharacters.get(object);
            string3 = string3.replace(((Character)object).charValue(), c2.charValue());
        }
        System.out.println("-- handling file part [" + string3 + "]");
        file = new File(String.valueOf(String.valueOf(this.workDir)) + File.separator + string3);
        if (file.exists() && !this.allowOverwrite) {
            if (this.silentlyRename) {
                int n = 1;
                while (file.exists()) {
                    file = new File(String.valueOf(String.valueOf(this.workDir)) + File.separator + new Integer(n).toString() + "_" + string3);
                    ++n;
                }
            } else {
                throw new UploadException("There is already a file called " + string3 + " in the upload directory");
            }
        }
        if (this.saveUploadedFilesToDisk) {
            object = new FileOutputStream(file);
            this.validChars = 0;
            string2 = this.readPartData((OutputStream)object, string, c);
            ((FileOutputStream)object).close();
            if (this.validChars > 0) {
                this.put((String)hashtable.get("name"), file);
            } else {
                file.delete();
            }
        } else {
            object = new ByteArrayOutputStream();
            string2 = this.readPartData((OutputStream)object, string, c);
            if (((ByteArrayOutputStream)object).size() > 0) {
                this.put((String)hashtable.get("name"), new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()));
            }
        }
        System.out.println("-- handled file part");
        return string2;
    }

    protected String handleInlinePart(Hashtable hashtable, char c, String string) throws IOException {
        String string2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("-- handling inline part [" + hashtable.get("name") + "]");
        string2 = this.readPartData(byteArrayOutputStream, string, c);
        this.put((String)hashtable.get("name"), byteArrayOutputStream.toString());
        System.out.println("-- handled inline part, value was [" + byteArrayOutputStream.toString() + "]");
        return string2;
    }

    protected String handlePart(String string, String string2) throws IOException, UploadException {
        Hashtable hashtable = this.handlePartHeaders(string);
        if (!hashtable.isEmpty()) {
            System.out.println("*** seeking part data");
            String string3 = (String)hashtable.get("content-type");
            if (string3 != null && string3.indexOf("multipart") > -1) {
                this.boundaries.push(string2);
                try {
                    this.readrfc1867(string3);
                }
                catch (EndOfPartException endOfPartException) {
                    string = endOfPartException.getMessage();
                }
                if (!string2.startsWith((String)this.boundaries.pop())) {
                    throw new IOException("Misnested multipart boundaries?");
                }
            } else {
                string = this.handlePartData(hashtable, string2);
            }
            System.out.println("-- handled data, returning [" + string + "]");
        }
        return string;
    }

    private String handlePartData(Hashtable hashtable, String string) throws IOException, UploadException {
        String string2 = null;
        String string3 = (String)hashtable.get("content-transfer-encoding");
        char c = '7';
        String string4 = (String)hashtable.get("name");
        if (string4 == null) {
            string4 = "unknown" + new Integer(this.anon++).toString();
            hashtable.put("name", string4);
        }
        if (string3 != null && (c = (char)(string3 = string3.toLowerCase()).charAt(0)) == 'b') {
            string3.charAt(1);
        }
        string2 = hashtable.get("filename") != null ? this.handleFilePart(hashtable, c, string) : this.handleInlinePart(hashtable, c, string);
        return string2;
    }

    private Hashtable handlePartHeaders(String string) throws IOException {
        Hashtable hashtable = new Hashtable();
        while (string != null && string.indexOf(58) > -1) {
            System.out.println("  -- Seeking new part headers in " + string);
            this.extractPartHeadersFromLine(string, hashtable);
            string = this.readLine();
        }
        if (string != null && string.trim().length() > 0) {
            System.out.println("Non-blank line [" + string + "] (first character [" + string.getBytes()[0] + "]) following part headers?");
        }
        return hashtable;
    }

    protected synchronized void put(String string, Object object) {
        Object v = this.values.get(string);
        if (v != null) {
            Vector<Object> vector = null;
            if (v instanceof Vector) {
                vector = (Vector<Object>)v;
            } else {
                vector = new Vector<Object>();
                vector.addElement(v);
                this.values.put(string, vector);
            }
            vector.addElement(object);
        } else {
            this.values.put(string, object);
        }
    }

    private String readLine() throws IOException {
        return this.readLine('7');
    }

    private String readLine(char c) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        do {
            if ((n = this.readLine(this.buf, 0, this.buf.length, c)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
        } while (n == this.buf.length);
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
            boolean bl = false;
            while (string.length() > 0 && !bl) {
                switch (string.charAt(string.length() - 1)) {
                    case '\n': 
                    case '\r': {
                        string = string.substring(0, string.length() - 1);
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
        }
        System.out.println("-- String readLine returning [" + string + "]; total read = " + this.read + " out of " + this.expected + " bytes expected");
        return string;
    }

    public int readLine(byte[] byArray, int n, int n2, char c) throws IOException {
        int n3 = 0;
        int n4 = -1;
        int n5 = 13;
        boolean bl = false;
        int n6 = -1;
        int n7 = -2;
        while (n6 != 0 && n3 < n2) {
            n7 = this.in.read();
            byArray[n3 + n] = (byte)n7;
            ++n3;
            ++this.read;
            block0 : switch (n6) {
                case 13: {
                    switch (n7) {
                        case -1: 
                        case 10: {
                            n6 = 0;
                            break block0;
                        }
                        case 13: {
                            n6 = 13;
                            break block0;
                        }
                    }
                    n6 = -1;
                    break;
                }
                default: {
                    switch (n7) {
                        case -1: {
                            n6 = 0;
                            break block0;
                        }
                        case 13: {
                            n6 = 13;
                            break block0;
                        }
                    }
                    n6 = -1;
                    break;
                }
            }
        }
        if (byArray[0] == -1) {
            n3 = 0;
        }
        return n3;
    }

    private String readPartData(OutputStream outputStream, String string, char c) throws IOException {
        boolean bl = false;
        boolean bl2 = true;
        int n = 3;
        int n2 = 4;
        int n3 = 5;
        int n4 = -1;
        int n5 = 45;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n6 = 0;
        int n7 = 0;
        String string2 = null;
        int c2 = -1;
        while (n7 != -1) {
            int n8 = this.in.read();
            ++this.read;
            block0 : switch (n7) {
                case 0: {
                    int n9;
                    switch (n8) {
                        case 13: {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            byteArrayOutputStream.write(n8);
                            n9 = this.in.read();
                            if (n9 == 10) {
                                byteArrayOutputStream.write(n9);
                                ++this.read;
                            } else {
                                this.in.unread(n9);
                            }
                            n7 = 1;
                            break block0;
                        }
                        case 10: {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            byteArrayOutputStream.write(n8);
                            n7 = 1;
                            break block0;
                        }
                        case -1: {
                            n7 = -1;
                        }
                    }
                    ++this.validChars;
                    outputStream.write(n8);
                    break;
                }
                case 1: {
                    switch (n8) {
                        case 45: {
                            byteArrayOutputStream.write(n8);
                            n7 = 3;
                            break block0;
                        }
                        case -1: {
                            byteArrayOutputStream.writeTo(outputStream);
                            n7 = -1;
                            break block0;
                        }
                    }
                    byteArrayOutputStream.write(n8);
                    byteArrayOutputStream.writeTo(outputStream);
                    n7 = 0;
                    break;
                }
                case 3: {
                    n6 = this.read - 1;
                    switch (n8) {
                        case 45: {
                            byteArrayOutputStream.write(n8);
                            n7 = 4;
                            break block0;
                        }
                        case -1: {
                            byteArrayOutputStream.writeTo(outputStream);
                            n7 = -1;
                            break block0;
                        }
                    }
                    byteArrayOutputStream.write(n8);
                    byteArrayOutputStream.writeTo(outputStream);
                    n7 = 0;
                    break;
                }
                case 4: {
                    switch (n8) {
                        case 45: {
                            byteArrayOutputStream.write(n8);
                            break block0;
                        }
                        case -1: {
                            byteArrayOutputStream.writeTo(outputStream);
                            n7 = -1;
                            break block0;
                        }
                    }
                    byteArrayOutputStream.write(n8);
                    n7 = 5;
                    break;
                }
                case 5: {
                    int n9 = this.read - n6;
                    byteArrayOutputStream.write(n8);
                    if (n8 == string.charAt(n9)) {
                        if (n9 + 1 != string.length()) break;
                        n7 = -1;
                        string2 = String.valueOf(string) + this.readLine();
                        break;
                    }
                    if (n8 == -1) {
                        n7 = -1;
                        break;
                    }
                    byteArrayOutputStream.writeTo(outputStream);
                    n7 = 0;
                    break;
                }
            }
        }
        return string2;
    }

    private String readrfc1867(String string) throws IOException, UploadException {
        String string2 = this.readLine();
        String string3 = this.getBoundary(string);
        while (string2 != null && string2.startsWith(string3)) {
            System.out.println("\n*** seeking new part");
            string2 = this.readLine();
            if (string2 == null) continue;
            if (string2.startsWith("--")) {
                if (string2.startsWith((String)this.boundaries.peek())) {
                    throw new EndOfPartException(string2);
                }
                throw new IOException("Unexpected recursive boundary: " + string2);
            }
            string2 = this.handlePart(string2, string3);
        }
        return string2;
    }
}

