/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl.validity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.excalibur.source.SourceValidity;

public final class AggregatedValidity
implements SourceValidity {
    private final List m_list = new ArrayList();

    public void add(SourceValidity validity) {
        this.m_list.add(validity);
    }

    public int isValid() {
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            int v = ((SourceValidity)i.next()).isValid();
            if (v >= 1) continue;
            return v;
        }
        return 1;
    }

    public boolean isValid(SourceValidity validity) {
        if (validity instanceof AggregatedValidity) {
            AggregatedValidity other = (AggregatedValidity)validity;
            List otherList = other.m_list;
            if (this.m_list.size() != otherList.size()) {
                return false;
            }
            Iterator i = this.m_list.iterator();
            Iterator j = otherList.iterator();
            while (i.hasNext()) {
                SourceValidity srcA = (SourceValidity)i.next();
                SourceValidity srcB = (SourceValidity)j.next();
                if (srcA.isValid() >= 1 || srcA.isValid(srcB)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SourceValidity ");
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }
}

