/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class CropRenderer
extends AbstractRenderer {
    protected Rectangle cachedArea = new Rectangle();
    protected Image cacheImage;

    public CropRenderer(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
    }

    public void paint(Graphics graphics) {
        this.blankBackground(graphics);
        JimiRasterImage jimiRasterImage = this.getRasterImage();
        if (jimiRasterImage == null) {
            return;
        }
        jimiRasterImage.waitInfoAvailable();
        int n = jimiRasterImage.getWidth();
        int n2 = jimiRasterImage.getHeight();
        int n3 = this.canvas.size().width;
        int n4 = this.canvas.size().height;
        int n5 = 0;
        int n6 = 0;
        int n7 = n - n3;
        int n8 = n2 - n4;
        int n9 = Math.min(n, n3);
        int n10 = Math.min(n2, n4);
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        int n11 = n7 / 2;
        int n12 = n8 / 2;
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                n5 = n11;
                n6 = n12;
                break;
            }
            case 18: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case 16: {
                n5 = 0;
                n6 = n12;
                break;
            }
            case 20: {
                n5 = 0;
                n6 = n8;
                break;
            }
            case 4: {
                n5 = n11;
                n6 = n8;
                break;
            }
            case 12: {
                n5 = n7;
                n6 = n8;
                break;
            }
            case 8: {
                n5 = n7;
                n6 = n12;
                break;
            }
            case 10: {
                n5 = n7;
                n6 = 0;
                break;
            }
            case 2: {
                n5 = n11;
                n6 = 0;
                break;
            }
        }
        if (this.cacheImage == null || this.cachedArea.x != n5 || this.cachedArea.y != n6 || this.cachedArea.width != n9 || this.cachedArea.height != n10) {
            ImageProducer imageProducer = jimiRasterImage.getCroppedImageProducer(n5, n6, n9, n10);
            this.cacheImage = Toolkit.getDefaultToolkit().createImage(imageProducer);
            GraphicsUtils.waitForImage(this.cacheImage);
            this.cachedArea.x = n5;
            this.cachedArea.y = n6;
            this.cachedArea.width = n9;
            this.cachedArea.height = n10;
        }
        this.image = this.cacheImage;
        super.paint(graphics);
    }

    public void render() {
        this.repaint();
    }
}

