/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeColorMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feColorMatrix";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        ColorMatrixRable colorMatrixRable;
        Filter filter2 = SVGFeColorMatrixElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        int n = SVGFeColorMatrixElementBridge.convertType(element);
        switch (n) {
            case 2: {
                float f = SVGFeColorMatrixElementBridge.convertValuesToHueRotate(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildHueRotate(f);
                break;
            }
            case 3: {
                colorMatrixRable = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            case 0: {
                float[][] fArray = SVGFeColorMatrixElementBridge.convertValuesToMatrix(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildMatrix(fArray);
                break;
            }
            case 1: {
                float f = SVGFeColorMatrixElementBridge.convertValuesToSaturate(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildSaturate(f);
                break;
            }
            default: {
                throw new Error();
            }
        }
        colorMatrixRable.setSource(filter2);
        SVGFeColorMatrixElementBridge.handleColorInterpolationFilters(colorMatrixRable, element);
        PadRable8Bit padRable8Bit = new PadRable8Bit(colorMatrixRable, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeColorMatrixElementBridge.updateFilterMap(element, padRable8Bit, map);
        return padRable8Bit;
    }

    protected static float[][] convertValuesToMatrix(Element element) {
        int n;
        String string = element.getAttributeNS(null, "values");
        float[][] fArray = new float[4][5];
        if (string.length() == 0) {
            fArray[0][0] = 1.0f;
            fArray[1][1] = 1.0f;
            fArray[2][2] = 1.0f;
            fArray[3][3] = 1.0f;
            return fArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            for (n = 0; n < 20 && stringTokenizer.hasMoreTokens(); ++n) {
                fArray[n / 5][n % 5] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string, numberFormatException});
        }
        if (n != 20 || stringTokenizer.hasMoreTokens()) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
        for (int i = 0; i < 4; ++i) {
            float[] fArray2 = fArray[i];
            fArray2[4] = fArray2[4] * 255.0f;
        }
        return fArray;
    }

    protected static float convertValuesToSaturate(Element element) {
        String string = element.getAttributeNS(null, "values");
        int n = string.length();
        if (string.length() == 0) {
            return 1.0f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static float convertValuesToHueRotate(Element element) {
        String string = element.getAttributeNS(null, "values");
        int n = string.length();
        if (string.length() == 0) {
            return 0.0f;
        }
        try {
            return (float)((double)SVGUtilities.convertSVGNumber(string) * Math.PI) / 180.0f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static int convertType(Element element) {
        String string = element.getAttributeNS(null, "type");
        int n = string.length();
        if (string.length() == 0) {
            return 0;
        }
        if ("hueRotate".equals(string)) {
            return 2;
        }
        if ("luminanceToAlpha".equals(string)) {
            return 3;
        }
        if ("matrix".equals(string)) {
            return 0;
        }
        if ("saturate".equals(string)) {
            return 1;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{"type", string});
    }
}

