/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractElement
extends AbstractParentChildNode
implements Element {
    protected NamedNodeMap attributes;

    protected AbstractElement() {
    }

    protected AbstractElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        if (!DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{string});
        }
    }

    public short getNodeType() {
        return 1;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes == null ? (this.attributes = this.createAttributes()) : this.attributes;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasAttribute(String string) {
        return this.attributes != null && this.attributes.getNamedItem(string) != null;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if ((attr = this.getAttributeNode(string)) == null) {
            attr = this.getOwnerDocument().createAttribute(string);
            attr.setValue(string2);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setValue(string2);
        }
    }

    public void removeAttribute(String string) throws DOMException {
        if (!this.hasAttribute(string)) {
            return;
        }
        this.attributes.removeNamedItem(string);
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{attr.getName()});
        }
        return (Attr)this.attributes.removeNamedItemNS(attr.getNamespaceURI(), attr.getLocalName());
    }

    public void normalize() {
        super.normalize();
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                namedNodeMap.item(i).normalize();
            }
        }
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.attributes != null && this.attributes.getNamedItemNS(string, string2) != null;
    }

    public String getAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(string, string2);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if ((attr = this.getAttributeNodeNS(string, string2)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(string, string2);
            attr.setValue(string3);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setValue(string3);
        }
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        if (!this.hasAttributeNS(string, string2)) {
            return;
        }
        this.attributes.removeNamedItemNS(string, string2);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    protected void nodeAdded(Node node) {
        this.invalidateElementsByTagName(node);
    }

    protected void nodeToBeRemoved(Node node) {
        this.invalidateElementsByTagName(node);
    }

    private void invalidateElementsByTagName(Node node) {
        Node node2;
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        String string = node.getNamespaceURI();
        String string2 = node.getNodeName();
        String string3 = string == null ? node.getNodeName() : node.getLocalName();
        block3: for (node2 = this; node2 != null; node2 = node2.getParentNode()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 9: {
                    AbstractParentNode.ElementsByTagNameNS elementsByTagNameNS;
                    AbstractParentNode.ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(node2, string2);
                    if (elementsByTagName != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, "*")) != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string, string3)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", string3)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string, "*")) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", "*")) == null) continue block3;
                    elementsByTagNameNS.invalidate();
                }
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.invalidateElementsByTagName(node2);
        }
    }

    protected NamedNodeMap createAttributes() {
        return new NamedNodeHashMap();
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    protected void checkChildType(Node node, boolean bl) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(node.getNodeType()), node.getNodeName()});
            }
        }
    }

    public void fireDOMAttrModifiedEvent(String string, Attr attr, String string2, String string3, short s) {
        switch (s) {
            case 2: {
                this.attrAdded(attr, string3);
                break;
            }
            case 1: {
                this.attrModified(attr, string2, string3);
                break;
            }
            default: {
                this.attrRemoved(attr, string2);
            }
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled() && !string2.equals(string3)) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMAttrModified", true, false, attr, string2, string3, string, s);
            this.dispatchEvent(mutationEvent);
        }
    }

    protected void attrAdded(Attr attr, String string) {
    }

    protected void attrModified(Attr attr, String string, String string2) {
    }

    protected void attrRemoved(Attr attr, String string) {
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public String namespaceURI;
        public String name;
        public Node value;
        public Entry next;

        public Entry(int n, String string, String string2, Node node, Entry entry) {
            this.hash = n;
            this.namespaceURI = string;
            this.name = string2;
            this.value = node;
            this.next = entry;
        }

        public boolean match(String string, String string2) {
            if (this.namespaceURI != null ? !this.namespaceURI.equals(string) : string != null) {
                return false;
            }
            return this.name.equals(string2);
        }
    }

    public class NamedNodeHashMap
    implements NamedNodeMap,
    Serializable {
        protected static final int INITIAL_CAPACITY = 3;
        protected Entry[] table = new Entry[3];
        protected int count;

        public Node getNamedItem(String string) {
            if (string == null) {
                return null;
            }
            return this.get(null, string);
        }

        public Node setNamedItem(Node node) throws DOMException {
            if (node == null) {
                return null;
            }
            this.checkNode(node);
            return this.setNamedItem(null, node.getNodeName(), node);
        }

        public Node removeNamedItem(String string) throws DOMException {
            return this.removeNamedItemNS(null, string);
        }

        public Node item(int n) {
            if (n < 0 || n >= this.count) {
                return null;
            }
            int n2 = 0;
            for (int i = 0; i < this.table.length; ++i) {
                Entry entry = this.table[i];
                if (entry == null) continue;
                do {
                    if (n2++ != n) continue;
                    return entry.value;
                } while ((entry = entry.next) != null);
            }
            return null;
        }

        public int getLength() {
            return this.count;
        }

        public Node getNamedItemNS(String string, String string2) {
            return this.get(string, string2);
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            String string;
            if (node == null) {
                return null;
            }
            return this.setNamedItem(string, (string = node.getNamespaceURI()) == null ? node.getNodeName() : node.getLocalName(), node);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            AbstractAttr abstractAttr = (AbstractAttr)this.remove(string, string2);
            if (abstractAttr == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            return abstractAttr;
        }

        public Node setNamedItem(String string, String string2, Node node) throws DOMException {
            ((AbstractAttr)node).setOwnerElement(AbstractElement.this);
            AbstractAttr abstractAttr = (AbstractAttr)this.put(string, string2, node);
            if (abstractAttr != null) {
                abstractAttr.setOwnerElement(null);
                AbstractElement.this.fireDOMAttrModifiedEvent(string2, abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            }
            AbstractElement.this.fireDOMAttrModifiedEvent(string2, (Attr)node, "", node.getNodeValue(), (short)2);
            return abstractAttr;
        }

        protected void checkNode(Node node) {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (AbstractElement.this.getOwnerDocument() != node.getOwnerDocument()) {
                throw AbstractElement.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
            }
            if (node.getNodeType() == 2 && ((Attr)node).getOwnerElement() != null) {
                throw AbstractElement.this.createDOMException((short)4, "inuse.attribute", new Object[]{node.getNodeName()});
            }
        }

        protected Node get(String string, String string2) {
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && entry.match(string, string2)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }

        protected Node put(String string, String string2, Node node) {
            Entry entry;
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(string, string2)) {
                    Node node2 = entry2.value;
                    entry2.value = node;
                    return node2;
                }
                entry2 = entry2.next;
            }
            int n3 = this.table.length;
            if (this.count++ >= n3 * 3 >>> 2) {
                this.rehash();
                n2 = n % this.table.length;
            }
            this.table[n2] = entry = new Entry(n, string, string2, node, this.table[n2]);
            return null;
        }

        protected Node remove(String string, String string2) {
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = null;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(string, string2)) {
                    Node node = entry2.value;
                    if (entry == null) {
                        this.table[n2] = entry2.next;
                    } else {
                        entry.next = entry2.next;
                    }
                    --this.count;
                    return node;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            for (int i = entryArray.length - 1; i >= 0; --i) {
                Entry entry = entryArray[i];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n = entry2.hash % this.table.length;
                    entry2.next = this.table[n];
                    this.table[n] = entry2;
                }
            }
        }

        protected int hashCode(String string, String string2) {
            int n = string == null ? 0 : string.hashCode();
            return n ^ string2.hashCode();
        }
    }
}

