/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.RAMFile;

final class RAMInputStream
extends InputStream
implements Cloneable {
    RAMFile file;
    int pointer = 0;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
    }

    public final void readInternal(byte[] dest, int destOffset, int len) {
        int remainder = len;
        int start = this.pointer;
        while (remainder != 0) {
            int bufferNumber = start / 1024;
            int bufferOffset = start % 1024;
            int bytesInBuffer = 1024 - bufferOffset;
            int bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += bytesToCopy;
            remainder -= bytesToCopy;
        }
        this.pointer += len;
    }

    public final void close() {
    }

    public final void seekInternal(long pos) {
        this.pointer = (int)pos;
    }
}

