/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractComplementaryConfigurableAction;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashMap;
import org.apache.cocoon.util.JDBCTypeConversions;

public abstract class DatabaseAction
extends AbstractComplementaryConfigurableAction
implements Configurable,
Disposable {
    static final Integer MODE_AUTOINCR = new Integer(0);
    static final Integer MODE_OTHERS = new Integer(1);
    static final Integer MODE_OUTPUT = new Integer(2);
    static final String ATTRIBUTE_KEY = "org.apache.cocoon.action.modular.DatabaseAction.outputModeName";
    static final String inputHint = "request-param";
    static final String outputHint = "request-attr";
    static final String databaseHint = "manual";
    static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    static final String OUTPUT_MODULE_SELECTOR = OutputModule.ROLE + "Selector";
    static final String DATABASE_MODULE_SELECTOR = "org.apache.cocoon.components.modules.database.AutoIncrementModuleSelector";
    protected ComponentSelector dbselector;
    protected Map defaultModeNames = new HashMap(3);
    protected final HashMap cachedQueryData = new HashMap();

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        if (this.settings != null) {
            this.defaultModeNames.put(MODE_OTHERS, (String)this.settings.get("input", inputHint));
            this.defaultModeNames.put(MODE_OUTPUT, (String)this.settings.get("output", outputHint));
            this.defaultModeNames.put(MODE_AUTOINCR, (String)this.settings.get("autoincrement", databaseHint));
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.dbselector = (ComponentSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
        super.compose(manager);
    }

    public void dispose() {
        this.manager.release((Component)this.dbselector);
    }

    protected DataSourceComponent getDataSource(Configuration conf, Parameters parameters) throws ComponentException {
        String sourceName = parameters.getParameter("connection", (String)this.settings.get("connection"));
        if (sourceName == null) {
            Configuration dsn = conf.getChild("connection");
            return (DataSourceComponent)this.dbselector.select((Object)dsn.getValue(""));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using datasource: " + sourceName);
        }
        return (DataSourceComponent)this.dbselector.select((Object)sourceName);
    }

    protected final boolean isLargeObject(String type) {
        if ("ascii".equals(type)) {
            return true;
        }
        if ("binary".equals(type)) {
            return true;
        }
        return "image".equals(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setOutputAttribute(Map objectModel, String outputMode, String key, Object value) {
        ComponentSelector outputSelector;
        block9: {
            outputSelector = null;
            OutputModule output = null;
            try {
                try {
                    outputSelector = (ComponentSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                    if (outputMode != null && outputSelector != null && outputSelector.hasComponent((Object)outputMode)) {
                        output = (OutputModule)outputSelector.select((Object)outputMode);
                    }
                    output.setAttribute(null, objectModel, key, value);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not select output mode " + outputMode + ":" + e.getMessage());
                    }
                    Object var9_8 = null;
                    if (outputSelector == null) return;
                    if (output != null) {
                        outputSelector.release((Component)output);
                    }
                    this.manager.release((Component)outputSelector);
                    return;
                }
                Object var9_7 = null;
                if (outputSelector == null) return;
                if (output == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (outputSelector == null) throw throwable;
                if (output != null) {
                    outputSelector.release(output);
                }
                this.manager.release((Component)outputSelector);
                throw throwable;
            }
            outputSelector.release((Component)output);
        }
        this.manager.release((Component)outputSelector);
    }

    protected int processTable(Configuration table, Connection conn, Map objectModel, Map results, Map modeTypes) throws SQLException, ConfigurationException, Exception {
        Statement statement = null;
        int rows = 0;
        try {
            LookUpKey luk = new LookUpKey(table, modeTypes);
            CacheHelper queryData = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("modeTypes : " + modeTypes);
            }
            HashMap hashMap = this.cachedQueryData;
            synchronized (hashMap) {
                queryData = (CacheHelper)this.cachedQueryData.get(luk, null);
                if (queryData == null) {
                    queryData = this.getQuery(table, modeTypes, this.defaultModeNames);
                    this.cachedQueryData.put(luk, queryData);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("query: " + queryData.queryString);
            }
            statement = conn.prepareStatement(queryData.queryString);
            Object[][] columnValues = this.getColumnValues(table, queryData, objectModel);
            int setLength = 1;
            if (queryData.isSet) {
                setLength = columnValues[queryData.setMaster] != null ? columnValues[queryData.setMaster].length : 0;
            }
            int rowIndex = 0;
            while (rowIndex < setLength) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("====> row no. " + rowIndex);
                }
                rows += this.processRow(objectModel, conn, (PreparedStatement)statement, (String)modeTypes.get(MODE_OUTPUT), table, queryData, columnValues, rowIndex, results);
                ++rowIndex;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {}
        return rows;
    }

    protected Configuration getMode(Configuration conf, String type) throws ConfigurationException {
        String modeAll = "all";
        Configuration[] modes = conf.getChildren("mode");
        Configuration modeConfig = null;
        int i = 0;
        while (i < modes.length) {
            String modeType = modes[i].getAttribute("type", "others");
            if (modeType.equals(type) || modeType.equals(modeAll)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("requested mode was \"" + type + "\" returning \"" + modeType + "\"");
                }
                modeConfig = modes[i];
                break;
            }
            ++i;
        }
        return modeConfig;
    }

    protected String getOutputName(Configuration tableConf, Configuration columnConf) {
        return this.getOutputName(tableConf, columnConf, -1);
    }

    protected String getOutputName(Configuration tableConf, Configuration columnConf, int rowIndex) {
        if (rowIndex != -1 && this.settings.containsKey("append-row") && (this.settings.get("append-row").toString().equalsIgnoreCase("false") || this.settings.get("append-row").toString().equalsIgnoreCase("0"))) {
            rowIndex = -1;
        }
        if (this.settings.containsKey("append-table-name") && (this.settings.get("append-table-name").toString().equalsIgnoreCase("false") || this.settings.get("append-table-name").toString().equalsIgnoreCase("0"))) {
            return columnConf.getAttribute("name", null) + (rowIndex == -1 ? "" : "[" + rowIndex + "]");
        }
        return tableConf.getAttribute("alias", tableConf.getAttribute("name", null)) + "." + columnConf.getAttribute("name", null) + (rowIndex == -1 ? "" : "[" + rowIndex + "]");
    }

    protected Object[] getColumnValue(Configuration tableConf, Column column, Map objectModel) throws ConfigurationException, ComponentException {
        Object[] values;
        block13: {
            ComponentSelector inputSelector;
            block14: {
                if (column.isAutoIncrement) {
                    return new Object[1];
                }
                String cname = this.getOutputName(tableConf, column.columnConf);
                inputSelector = null;
                InputModule input = null;
                try {
                    inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (column.mode != null && inputSelector != null && inputSelector.hasComponent((Object)column.mode)) {
                        input = (InputModule)inputSelector.select((Object)column.mode);
                    }
                    if (column.isSet) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Trying to set column " + cname + " from " + column.mode + " using getAttributeValues method");
                        }
                        values = input.getAttributeValues(cname, column.modeConf, objectModel);
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Trying to set column " + cname + " from " + column.mode + " using getAttribute method");
                        }
                        values = new Object[]{input.getAttribute(cname, column.modeConf, objectModel)};
                    }
                    if (values != null) {
                        int i = 0;
                        while (i < values.length) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Setting column " + cname + " [" + i + "] " + values[i]);
                            }
                            ++i;
                        }
                    }
                    Object var10_9 = null;
                    if (inputSelector == null) break block13;
                    if (input == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (inputSelector != null) {
                        if (input != null) {
                            inputSelector.release(input);
                        }
                        this.manager.release((Component)inputSelector);
                    }
                    throw throwable;
                }
                inputSelector.release((Component)input);
            }
            this.manager.release((Component)inputSelector);
            {
            }
        }
        return values;
    }

    protected void fillModes(Configuration[] conf, boolean isKey, Map defaultModeNames, Map modeTypes, CacheHelper set) throws ConfigurationException {
        int offset;
        String setMode = null;
        int setMaster = -1;
        Object setMastersMode = null;
        boolean manyrows = false;
        int i = offset = isKey ? 0 : set.noOfKeys;
        while (i < conf.length + offset) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("i=" + i);
            }
            set.columns[i].columnConf = conf[i - offset];
            set.columns[i].isSet = false;
            set.columns[i].isKey = isKey;
            set.columns[i].isAutoIncrement = false;
            if (isKey & this.honourAutoIncrement()) {
                set.columns[i].isAutoIncrement = set.columns[i].columnConf.getAttributeAsBoolean("autoincrement", false);
            }
            set.columns[i].modeConf = this.getMode(set.columns[i].columnConf, this.selectMode(set.columns[i].isAutoIncrement, modeTypes));
            set.columns[i].mode = set.columns[i].modeConf != null ? set.columns[i].modeConf.getAttribute("name", this.selectMode(isKey, defaultModeNames)) : this.selectMode(isKey, defaultModeNames);
            setMode = set.columns[i].columnConf.getAttribute("set", null);
            if (setMode == null && set.columns[i].modeConf != null) {
                setMode = set.columns[i].modeConf.getAttribute("set", null);
            }
            if (setMode != null) {
                manyrows = true;
                set.columns[i].isSet = true;
                set.isSet = true;
                if (setMode.equals("master")) {
                    set.setMaster = i;
                }
            }
            ++i;
        }
    }

    protected void setOutput(Map objectModel, String outputMode, Map results, Configuration table, Configuration column, int rowIndex, Object value) {
        String param = this.getOutputName(table, column, rowIndex);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting column " + param + " to " + value);
        }
        this.setOutputAttribute(objectModel, outputMode, param, value);
        if (results != null) {
            results.put(param, String.valueOf(value));
        }
    }

    protected void setColumn(PreparedStatement statement, int position, Configuration entry, Object value) throws Exception {
        JDBCTypeConversions.setColumn(statement, position, value, (Integer)JDBCTypeConversions.typeConstants.get(entry.getAttribute("type")));
    }

    protected void setColumn(Map objectModel, String outputMode, Map results, Configuration table, Configuration column, int rowIndex, Object value, PreparedStatement statement, int position) throws Exception {
        if (results != null) {
            this.setOutput(objectModel, outputMode, results, table, column, rowIndex, value);
        }
        this.setColumn(statement, position, column, value);
    }

    /*
     * Loose catch block
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        int rows;
        HashMap results;
        block67: {
            String outputMode;
            Connection conn;
            DataSourceComponent datasource;
            block63: {
                block61: {
                    OutputModule output;
                    ComponentSelector outputSelector;
                    block62: {
                        Configuration conf;
                        block60: {
                            datasource = null;
                            conn = null;
                            results = new HashMap();
                            rows = 0;
                            boolean reloadable = true;
                            outputMode = param.getParameter("output", (String)this.defaultModeNames.get(MODE_OUTPUT));
                            if (this.settings.containsKey("reloadable")) {
                                reloadable = Boolean.valueOf((String)this.settings.get("reloadable"));
                            }
                            conf = this.getConfiguration(param.getParameter("descriptor", (String)this.settings.get("descriptor")), resolver, param.getParameterAsBoolean("reloadable", reloadable));
                            datasource = this.getDataSource(conf, param);
                            conn = datasource.getConnection();
                            if (conn.getAutoCommit()) {
                                try {
                                    conn.setAutoCommit(false);
                                }
                                catch (Exception ex) {
                                    String tmp = param.getParameter("use-transactions", (String)this.settings.get("use-transactions", null));
                                    if (tmp == null || !tmp.equalsIgnoreCase("no") && !tmp.equalsIgnoreCase("false") && !tmp.equalsIgnoreCase("0")) break block60;
                                    if (this.getLogger().isErrorEnabled()) {
                                        this.getLogger().error("This DB connection does not support transactions. If you want to risk your data's integrity by continuing nonetheless set parameter \"use-transactions\" to \"no\".");
                                    }
                                    throw ex;
                                }
                            }
                        }
                        Configuration[] tables = conf.getChildren("table");
                        String tablesetname = param.getParameter("table-set", (String)this.settings.get("table-set"));
                        Object set_tables = null;
                        HashMap modeTypes = null;
                        if (tablesetname == null) {
                            modeTypes = new HashMap(6);
                            modeTypes.put(MODE_AUTOINCR, "autoincr");
                            modeTypes.put(MODE_OTHERS, "others");
                            modeTypes.put(MODE_OUTPUT, outputMode);
                            int i = 0;
                            while (i < tables.length) {
                                rows += this.processTable(tables[i], conn, objectModel, results, modeTypes);
                                ++i;
                            }
                        } else {
                            HashMap tableIndex = new HashMap(2 * tables.length);
                            String tableName = null;
                            Integer result = null;
                            int i = 0;
                            while (i < tables.length) {
                                tableName = tables[i].getAttribute("alias", tables[i].getAttribute("name", ""));
                                result = tableIndex.put(tableName, new Integer(i));
                                if (result != null) {
                                    throw new IOException("Duplicate table entry for " + tableName + " at positions " + result + " and " + i);
                                }
                                ++i;
                            }
                            Configuration[] tablesets = conf.getChildren("table-set");
                            String setname = null;
                            boolean found = false;
                            int j = 0;
                            j = 0;
                            while (j < tablesets.length) {
                                setname = tablesets[j].getAttribute("name", "");
                                if (tablesetname.trim().equals(setname.trim())) {
                                    found = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!found) {
                                throw new IOException(" given set " + tablesetname + " does not exists in a description file.");
                            }
                            Configuration[] set = tablesets[j].getChildren("table");
                            int i2 = 0;
                            while (i2 < set.length) {
                                modeTypes = new HashMap(6);
                                modeTypes.put(MODE_AUTOINCR, set[i2].getAttribute("autoincr-mode", "autoincr"));
                                modeTypes.put(MODE_OTHERS, set[i2].getAttribute("others-mode", "others"));
                                modeTypes.put(MODE_OUTPUT, outputMode);
                                tableName = set[i2].getAttribute("name", "");
                                if (tableIndex.containsKey(tableName)) {
                                    j = (Integer)tableIndex.get(tableName);
                                    rows += this.processTable(tables[j], conn, objectModel, results, modeTypes);
                                } else {
                                    throw new IOException(" given table " + tableName + " does not exists in a description file.");
                                }
                                ++i2;
                            }
                        }
                        if (!conn.getAutoCommit()) {
                            conn.commit();
                        }
                        outputSelector = null;
                        output = null;
                        try {
                            outputSelector = (ComponentSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                            if (outputMode != null && outputSelector != null && outputSelector.hasComponent((Object)outputMode)) {
                                output = (OutputModule)outputSelector.select((Object)outputMode);
                            }
                            output.commit(null, objectModel);
                            Object var28_36 = null;
                            if (outputSelector == null) break block61;
                            if (output == null) break block62;
                        }
                        catch (Throwable throwable) {
                            Object var28_38 = null;
                            if (outputSelector != null) {
                                if (output != null) {
                                    outputSelector.release(output);
                                }
                                this.manager.release((Component)outputSelector);
                            }
                            throw throwable;
                        }
                        outputSelector.release((Component)output);
                    }
                    this.manager.release((Component)outputSelector);
                    {
                        break block61;
                        catch (Exception e) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("Could not select output mode " + outputMode + ":" + e.getMessage());
                            }
                            Object var28_37 = null;
                            if (outputSelector != null) {
                                if (output != null) {
                                    outputSelector.release((Component)output);
                                }
                                this.manager.release((Component)outputSelector);
                            }
                        }
                    }
                }
                Object var32_40 = null;
                if (conn == null) break block63;
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release((Component)datasource);
            }
            break block67;
            {
                catch (Exception e) {
                    String throwException;
                    block64: {
                        if (conn != null) {
                            try {
                                OutputModule output;
                                ComponentSelector outputSelector;
                                block65: {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("Rolling back transaction. Caused by " + e.getMessage());
                                        e.printStackTrace();
                                    }
                                    conn.rollback();
                                    results = null;
                                    outputSelector = null;
                                    output = null;
                                    try {
                                        outputSelector = (ComponentSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                                        if (outputMode != null && outputSelector != null && outputSelector.hasComponent((Object)outputMode)) {
                                            output = (OutputModule)outputSelector.select((Object)outputMode);
                                        }
                                        output.rollback(null, objectModel, e);
                                        Object var30_46 = null;
                                        if (outputSelector == null) break block64;
                                        if (output == null) break block65;
                                    }
                                    catch (Throwable throwable) {
                                        Object var30_48 = null;
                                        if (outputSelector != null) {
                                            if (output != null) {
                                                outputSelector.release(output);
                                            }
                                            this.manager.release((Component)outputSelector);
                                        }
                                        throw throwable;
                                    }
                                    outputSelector.release((Component)output);
                                }
                                this.manager.release((Component)outputSelector);
                                {
                                    break block64;
                                    catch (Exception e2) {
                                        if (this.getLogger().isWarnEnabled()) {
                                            this.getLogger().warn("Could not select output mode " + outputMode + ":" + e2.getMessage());
                                        }
                                        Object var30_47 = null;
                                        if (outputSelector != null) {
                                            if (output != null) {
                                                outputSelector.release((Component)output);
                                            }
                                            this.manager.release((Component)outputSelector);
                                        }
                                    }
                                }
                            }
                            catch (SQLException se) {
                                if (!this.getLogger().isDebugEnabled()) break block64;
                                this.getLogger().debug("There was an error rolling back the transaction", (Throwable)se);
                            }
                        }
                    }
                    if ((throwException = (String)this.settings.get("throw-exception", param.getParameter("throw-exception", null))) != null && (throwException.equalsIgnoreCase("true") || throwException.equalsIgnoreCase("yes"))) {
                        throw new ProcessingException("Could not add record", e);
                    }
                    Object var32_41 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sqe) {
                            this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                        }
                    }
                    if (datasource != null) {
                        this.dbselector.release((Component)datasource);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var32_42 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                    }
                }
                if (datasource != null) {
                    this.dbselector.release(datasource);
                }
                throw throwable;
            }
        }
        if (results != null) {
            if (rows > 0) {
                results.put("row-count", new Integer(rows));
            } else {
                results = null;
            }
        } else if (rows > 0) {
            results = new HashMap(1);
            results.put("row-count", new Integer(rows));
        }
        return results;
    }

    protected abstract int processRow(Map var1, Connection var2, PreparedStatement var3, String var4, Configuration var5, CacheHelper var6, Object[][] var7, int var8, Map var9) throws SQLException, ConfigurationException, Exception;

    protected abstract String selectMode(boolean var1, Map var2);

    protected abstract boolean honourAutoIncrement();

    abstract Object[][] getColumnValues(Configuration var1, CacheHelper var2, Map var3) throws ConfigurationException, ComponentException;

    protected abstract CacheHelper getQuery(Configuration var1, Map var2, Map var3) throws ConfigurationException, ComponentException;

    protected class LookUpKey {
        public Configuration tableConf = null;
        public Map modeTypes = null;

        public LookUpKey(Configuration tableConf, Map modeTypes) {
            this.tableConf = tableConf;
            this.modeTypes = modeTypes;
        }
    }

    protected class CacheHelper {
        public String queryString = null;
        public int setMaster = -1;
        public boolean isSet = false;
        public int noOfKeys = 0;
        public Column[] columns = null;

        public CacheHelper(int cols) {
            this(0, cols);
        }

        public CacheHelper(int keys, int cols) {
            this.noOfKeys = keys;
            this.columns = new Column[cols];
            int i = 0;
            while (i < cols) {
                this.columns[i] = new Column();
                ++i;
            }
        }
    }

    protected class Column {
        boolean isKey = false;
        boolean isSet = false;
        boolean isAutoIncrement = false;
        String mode = null;
        Configuration modeConf = null;
        Configuration columnConf = null;

        protected Column() {
        }
    }
}

