/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

class Cell {
    private HSSFCell _cell;
    private int _celltype;

    Cell(HSSFCell cell, int cellType) {
        this._cell = cell;
        this._celltype = cellType;
    }

    void setContent(String content) throws IOException {
        if (this._cell.getCellType() == 0) {
            try {
                if (this._celltype == 40) {
                    this._cell.setCellValue(Double.parseDouble(content));
                }
                this._cell.setCellValue((double)Integer.parseInt(content));
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid value for a numeric cell: " + content);
            }
        } else if (this._cell.getCellType() == 1) {
            this._cell.setCellValue(content);
        }
    }

    void setStyle(HSSFCellStyle style) {
        if (style != null) {
            this._cell.setCellStyle(style);
        }
    }

    int getCellType() {
        return this._cell.getCellType();
    }

    String getStringValue() {
        return this._cell.getStringCellValue();
    }

    double getNumericValue() {
        return this._cell.getNumericCellValue();
    }
}

