/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.AbstractMarkupLanguage;
import org.apache.cocoon.components.language.markup.LogicsheetCodeGenerator;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class CocoonMarkupLanguage
extends AbstractMarkupLanguage {
    private final Set dependencies = new HashSet();

    public void recycle() {
        super.recycle();
        this.dependencies.clear();
    }

    protected XMLFilter getPreprocessFilter(String filename, ProgrammingLanguage language) {
        PreProcessFilter filter = new PreProcessFilter(filename, language);
        filter.setLogger(this.getLogger());
        return filter;
    }

    protected AbstractMarkupLanguage.TransformerChainBuilderFilter getTransformerChainBuilder(LogicsheetCodeGenerator logicsheetMarkupGenerator, SourceResolver resolver) {
        CocoonTransformerChainBuilderFilter filter = new CocoonTransformerChainBuilderFilter(logicsheetMarkupGenerator, resolver);
        filter.setLogger(this.getLogger());
        return filter;
    }

    protected void addLogicsheetToList(AbstractMarkupLanguage.LanguageDescriptor language, String logicsheetLocation, SourceResolver resolver) throws IOException, SAXException, ProcessingException {
        super.addLogicsheetToList(language, logicsheetLocation, resolver);
    }

    protected void addDependency(String location) {
        this.dependencies.add(location);
    }

    public String getURI() {
        return this.uri;
    }

    public abstract String getRootElement();

    public class CocoonTransformerChainBuilderFilter
    extends AbstractMarkupLanguage.TransformerChainBuilderFilter
    implements Loggable {
        protected Logger log;
        private List startPrefix;
        private Object[] rootElement;
        private StringBuffer rootChars;
        private boolean isRootElem;
        private boolean insideRootElement;
        private boolean finished;
        private String localPrefix;

        public CocoonTransformerChainBuilderFilter(LogicsheetCodeGenerator logicsheetMarkupGenerator, SourceResolver resolver) {
            super(logicsheetMarkupGenerator, resolver);
        }

        public void setLogger(Logger logger) {
            if (this.log == null) {
                this.log = logger;
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if ("xml-logicsheet".equals(target)) {
                int start = data.indexOf("href");
                if (start >= 0) {
                    char quote = data.charAt((start += 6) - 1);
                    int end = data.indexOf(quote, start);
                    String href = data.substring(start, end);
                    try {
                        CocoonMarkupLanguage.this.addLogicsheetToList(this.language, href, this.resolver);
                    }
                    catch (ProcessingException pe) {
                        this.log.warn("ProcessingException in SitemapMarkupLanguage", (Throwable)((Object)pe));
                        throw new SAXException((Exception)((Object)pe));
                    }
                    catch (IOException ioe) {
                        this.log.warn("CocoonMarkupLanguage.processingInstruction", (Throwable)ioe);
                        throw new SAXException(ioe);
                    }
                }
                return;
            }
            super.processingInstruction(target, data);
        }

        public void startDocument() throws SAXException {
            this.isRootElem = true;
            this.insideRootElement = false;
            this.finished = false;
            this.startPrefix = new ArrayList();
            this.rootChars = new StringBuffer();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.finished) {
                super.startElement(namespaceURI, localName, qName, atts);
            } else if (this.isRootElem) {
                this.localPrefix = "";
                if (qName.indexOf(58) != -1) {
                    this.localPrefix = qName.substring(0, qName.indexOf(58));
                }
                this.isRootElem = false;
                this.rootElement = new Object[4];
                this.rootElement[0] = namespaceURI;
                this.rootElement[1] = localName;
                this.rootElement[2] = qName;
                this.rootElement[3] = atts;
            } else {
                this.insideRootElement = true;
                if (CocoonMarkupLanguage.this.getURI().equals(namespaceURI) && "logicsheet".equals(localName)) {
                    String href = atts.getValue("location");
                    try {
                        CocoonMarkupLanguage.this.addLogicsheetToList(this.language, href, this.resolver);
                    }
                    catch (ProcessingException pe) {
                        this.log.warn("CocoonMarkupLanguage.startElement", (Throwable)((Object)pe));
                        throw new SAXException((Exception)((Object)pe));
                    }
                    catch (IOException ioe) {
                        this.log.warn("CocoonMarkupLanguage.startElement", (Throwable)ioe);
                        throw new SAXException(ioe);
                    }
                } else {
                    this.finished = true;
                    super.startDocument();
                    int i = 0;
                    while (i < this.startPrefix.size()) {
                        String[] prefixArray = (String[])this.startPrefix.get(i);
                        super.startPrefixMapping(prefixArray[0], prefixArray[1]);
                        ++i;
                    }
                    super.startElement((String)this.rootElement[0], (String)this.rootElement[1], (String)this.rootElement[2], (Attributes)this.rootElement[3]);
                    char[] ch = this.rootChars.toString().toCharArray();
                    if (ch.length > 0) {
                        super.characters(ch, 0, ch.length);
                    }
                    Iterator iter = CocoonMarkupLanguage.this.dependencies.iterator();
                    while (iter.hasNext()) {
                        super.startElement((String)this.rootElement[0], "dependency", this.localPrefix + ":dependency", new AttributesImpl());
                        char[] locationChars = ((String)iter.next()).toCharArray();
                        super.characters(locationChars, 0, locationChars.length);
                        super.endElement((String)this.rootElement[0], "dependency", this.localPrefix + ":dependency");
                    }
                    super.startElement(namespaceURI, localName, qName, atts);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.finished) {
                super.endElement(namespaceURI, localName, qName);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.finished) {
                super.characters(ch, start, length);
            } else if (!this.insideRootElement) {
                this.rootChars.append(ch, start, length);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.finished) {
                super.startPrefixMapping(prefix, uri);
            } else {
                String[] prefixArray = new String[]{prefix, uri};
                this.startPrefix.add(prefixArray);
            }
        }
    }

    public class PreProcessFilter
    extends XMLFilterImpl
    implements Loggable {
        protected Logger log;
        protected String filename;
        protected boolean isRootElem;
        protected ProgrammingLanguage language;
        protected String localPrefix;

        public PreProcessFilter(String filename, ProgrammingLanguage language) {
            this.filename = filename;
            this.language = language;
        }

        public void setLogger(Logger logger) {
            if (this.log == null) {
                this.log = logger;
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.isRootElem = true;
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (!"xml-logicsheet".equals(target)) {
                data = this.language.quoteString(data);
            }
            super.processingInstruction(target, data);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (CocoonMarkupLanguage.this.getURI().equals(uri)) {
                this.localPrefix = prefix;
            }
            super.startPrefixMapping(prefix, uri);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.isRootElem) {
                if (!CocoonMarkupLanguage.this.getURI().equals(namespaceURI) || !CocoonMarkupLanguage.this.getRootElement().equals(localName)) {
                    throw new SAXException("This page is not valid page of this markup langugage. Root element is: " + namespaceURI + ":" + localName + ", must be: " + CocoonMarkupLanguage.this.getURI() + ":" + CocoonMarkupLanguage.this.getRootElement());
                }
                this.isRootElem = false;
                int pos = this.filename.lastIndexOf(File.separatorChar);
                String name = this.filename.substring(pos + 1);
                String path = this.filename.substring(0, pos).replace(File.separatorChar, '/');
                AttributesImpl newAtts = atts == null || atts.getLength() == 0 ? new AttributesImpl() : new AttributesImpl(atts);
                newAtts.addAttribute("", "file-name", "file-name", "CDATA", name);
                newAtts.addAttribute("", "file-path", "file-path", "CDATA", path);
                newAtts.addAttribute("", "creation-date", "creation-date", "CDATA", String.valueOf(System.currentTimeMillis()));
                super.startElement(namespaceURI, localName, qName, newAtts);
            } else {
                super.startElement(namespaceURI, localName, qName, atts);
            }
        }
    }
}

