/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.language.markup.xsp.XSPObjectHelper;
import org.apache.cocoon.components.modules.input.InputModule;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSPModuleHelper {
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final String URI = "input";
    private static final String PREFIX = "http://apache.org/cocoon/xsp/input/1.0";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    Map inputModules = null;
    ComponentManager manager = null;
    ComponentSelector inputSelector = null;

    private Object get(int op, String name, String attr, Map objectModel) throws RuntimeException {
        Object[] value = null;
        InputModule input = null;
        Configuration conf = null;
        if (this.inputModules == null) {
            this.inputModules = new HashMap();
        } else if (this.inputModules.containsKey(name)) {
            input = (InputModule)this.inputModules.get(name);
        }
        try {
            if (this.inputSelector == null) {
                this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
            }
            if (input == null) {
                if (this.inputSelector.hasComponent((Object)name)) {
                    input = (InputModule)this.inputSelector.select((Object)name);
                    this.inputModules.put(name, input);
                } else {
                    throw new RuntimeException("No such InputModule: " + name);
                }
            }
            switch (op) {
                case 0: {
                    value = input.getAttribute(attr, conf, objectModel);
                    break;
                }
                case 1: {
                    value = input.getAttributeValues(attr, conf, objectModel);
                    break;
                }
                case 2: {
                    value = input.getAttributeNames(conf, objectModel);
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("A problem obtaining a value from " + name + " occurred", (Throwable)e);
        }
        return value;
    }

    public void setup(ComponentManager manager) throws RuntimeException {
        this.inputModules = new HashMap();
        this.manager = manager;
        try {
            this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
            if (!(this.inputSelector instanceof ThreadSafe)) {
                this.manager.release((Component)this.inputSelector);
                this.inputSelector = null;
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not obtain selector for InputModule.", (Throwable)e);
        }
    }

    public Object getAttribute(Map objectModel, String module, String name, Object deflt) throws RuntimeException {
        Object result = this.get(0, module, name, objectModel);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object[] getAttributeValues(Map objectModel, String module, String name, Object[] deflt) throws RuntimeException {
        Object[] result = (Object[])this.get(1, module, name, objectModel);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public void getAttributeValues(Map objectModel, ContentHandler contentHandler, String module, String name) throws SAXException, RuntimeException {
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "attribute-values", attr);
        Object[] values = this.getAttributeValues(objectModel, module, name, null);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "value", String.valueOf(values[i]));
                ++i;
            }
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "attribute-values");
    }

    public Iterator getAttributeNames(Map objectModel, String module) throws RuntimeException {
        return (Iterator)this.get(2, module, null, objectModel);
    }

    public void getAttributeNames(Map objectModel, ContentHandler contentHandler, String module) throws SAXException, RuntimeException {
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "attribute-names");
        Iterator iter = this.getAttributeNames(objectModel, module);
        while (iter.hasNext()) {
            String name = (String)iter.next();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "name", name);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "attribute-names");
    }

    public void releaseAll() throws RuntimeException {
        if (this.manager != null && this.inputModules != null) {
            try {
                if (this.inputSelector == null) {
                    this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                }
                Iterator iter = this.inputModules.keySet().iterator();
                while (iter.hasNext()) {
                    this.inputSelector.release((Component)((InputModule)this.inputModules.get(iter.next())));
                }
                this.inputModules = null;
                this.manager.release((Component)this.inputSelector);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Could not release InputModules.", (Throwable)e);
            }
        }
    }
}

