/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceFactory;
import org.apache.cocoon.components.source.XMLDBSource;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Source;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class XMLDBSourceFactory
extends AbstractLoggable
implements SourceFactory,
Configurable,
Composable {
    protected String driver;
    protected ComponentManager m_manager;
    protected HashMap driverMap;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            this.driverMap = new HashMap();
            Configuration[] xmldbConfigs = conf.getChildren("driver");
            int i = 0;
            while (i < xmldbConfigs.length) {
                String type = xmldbConfigs[i].getAttribute("type");
                String driver = xmldbConfigs[i].getAttribute("class");
                this.driverMap.put(type, driver);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Initializing XML:DB connection, using driver " + driver);
                }
                try {
                    Class<?> c = Class.forName(driver);
                    DatabaseManager.registerDatabase((Database)((Database)c.newInstance()));
                }
                catch (XMLDBException xde) {
                    String error = "Unable to connect to the XMLDB database. Error " + xde.errorCode + ": " + xde.getMessage();
                    this.getLogger().debug(error, (Throwable)xde);
                    throw new ConfigurationException(error, (Throwable)xde);
                }
                catch (Exception e) {
                    this.getLogger().error("There was a problem setting up the connection");
                    this.getLogger().error("Make sure that your driver is available");
                    throw new ConfigurationException("Problem setting up the connection to XML:DB: " + e.getMessage(), (Throwable)e);
                }
                ++i;
            }
        } else {
            throw new ConfigurationException("XMLDB configuration not found");
        }
    }

    public void compose(ComponentManager cm) {
        this.m_manager = cm;
    }

    public Source getSource(Environment environment, String location) throws ProcessingException, IOException, MalformedURLException {
        int start = location.indexOf(58) + 1;
        int end = location.indexOf(58, start);
        if ((start == -1 || end == -1) && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Mispelled XML:DB URL. The syntax is \"xmldb:databasetype://host/collection/resource\"");
            throw new MalformedURLException("Mispelled XML:DB URL. The syntax is \"xmldb:databasetype://host/collection/resource\"");
        }
        String type = location.substring(start, end);
        this.driver = (String)this.driverMap.get(type);
        if (this.driver == null) {
            this.getLogger().error("Unable to find a driver for the \"" + type + " \" database type, please check the configuration");
            throw new ProcessingException("Unable to find a driver for the \"" + type + " \" database type, please check the configuration");
        }
        return new XMLDBSource(environment, this.m_manager, this.getLogger(), location);
    }

    public Source getSource(Environment environment, URL base, String location) throws ProcessingException, IOException, MalformedURLException {
        return this.getSource(environment, base.toExternalForm() + location);
    }
}

