/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;

public class PipelineNode
extends AbstractParentProcessingNode
implements Composable,
ParameterizableProcessingNode {
    private ProcessingNode[] children;
    private ProcessingNode error404;
    private ProcessingNode error500;
    private ComponentManager manager;
    private boolean internalOnly = false;
    private boolean isLast = false;
    protected String processingPipeline;
    protected Map parameters;

    public PipelineNode(Configuration config2) {
        this.processingPipeline = config2.getAttribute("type", null);
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    public void set404Handler(ProcessingNode node) {
        this.error404 = node;
    }

    public void set500Handler(ProcessingNode node) {
        this.error500 = node;
    }

    public void setInternalOnly(boolean internalOnly) {
        this.internalOnly = internalOnly;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        if (this.internalOnly && !context.isInternalRequest()) {
            return false;
        }
        try {
            if (this.invokeNodes(this.children, env, context)) {
                return true;
            }
            if (this.isLast) {
                String msg = "No pipeline matched request: " + env.getURIPrefix() + env.getURI();
                this.getLogger().info(msg);
                throw new ResourceNotFoundException(msg);
            }
            return false;
        }
        catch (ConnectionResetException cre) {
            throw cre;
        }
        catch (ResourceNotFoundException rnfe) {
            this.getLogger().info("Resource not found in pipeline at " + this.getLocation(), (Throwable)((Object)rnfe));
            if (this.error404 != null) {
                return this.invokeErrorHandler(this.error404, (Exception)((Object)rnfe), env);
            }
            throw rnfe;
        }
        catch (Exception e) {
            if (this.error500 != null && !context.isInternalRequest()) {
                this.getLogger().info("Error while processing pipeline at " + this.getLocation(), (Throwable)e);
                return this.invokeErrorHandler(this.error500, e, env);
            }
            this.getLogger().info("Error while processing pipeline at " + this.getLocation(), (Throwable)e);
            throw e;
        }
    }

    private boolean invokeErrorHandler(ProcessingNode node, Exception ex, Environment env) throws Exception {
        InvokeContext errorContext = null;
        try {
            try {
                env.tryResetResponse();
                errorContext = new InvokeContext();
                errorContext.setLogger(this.getLogger());
                errorContext.compose(this.manager);
                NotifyingBuilder notifyingBuilder = (NotifyingBuilder)this.manager.lookup("org.apache.cocoon.components.notification.NotifyingBuilder");
                Notifying currentNotifying = null;
                try {
                    currentNotifying = notifyingBuilder.build(this, ex);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.manager.release((Component)notifyingBuilder);
                    throw throwable;
                }
                this.manager.release((Component)notifyingBuilder);
                env.getObjectModel().put("notifying-object", currentNotifying);
                boolean bl = node.invoke(env, errorContext);
                Object var10_13 = null;
                if (errorContext != null) {
                    errorContext.dispose();
                }
                return bl;
            }
            catch (Exception subEx) {
                this.getLogger().error("Error notifier is unable to notify the problem. Please check the logs. In the default webapp, look in the WEB-INF/logs dir.", (Throwable)subEx);
                boolean bl = false;
                Object var10_14 = null;
                if (errorContext != null) {
                    errorContext.dispose();
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            block8: {
                Object var10_15 = null;
                if (errorContext == null) break block8;
                errorContext.dispose();
            }
            throw throwable;
        }
    }
}

