/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.commandline.CommandLineSession;

public class CommandLineRequest
implements Request {
    private Environment env;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private Map attributes;
    private Map parameters;
    private Map headers;
    private String characterEncoding = null;

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo) {
        this(env, contextPath, servletPath, pathInfo, null, null, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes) {
        this(env, contextPath, servletPath, pathInfo, attributes, null, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters) {
        this(env, contextPath, servletPath, pathInfo, attributes, parameters, null);
    }

    public CommandLineRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters, Map headers) {
        this.env = env;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.parameters = parameters;
        this.headers = headers;
    }

    public Object get(String name) {
        return this.getAttribute(name);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestURI() {
        StringBuffer buffer = new StringBuffer();
        if (this.servletPath != null) {
            buffer.append(this.servletPath);
        }
        if (this.contextPath != null) {
            buffer.append(this.contextPath);
        }
        if (this.pathInfo != null) {
            buffer.append(this.pathInfo);
        }
        return buffer.toString();
    }

    public String getSitemapURI() {
        return this.env.getURI();
    }

    public String getQueryString() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorWrapper(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getParameter(String name) {
        return this.parameters != null ? (String)this.parameters.get(name) : null;
    }

    public Enumeration getParameterNames() {
        return this.parameters != null ? new IteratorWrapper(this.parameters.keySet().iterator()) : null;
    }

    public String[] getParameterValues(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            return new String[]{value};
        }
        return null;
    }

    public String getHeader(String name) {
        return this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
    }

    public int getIntHeader(String name) {
        String header = this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
        return header != null ? Integer.parseInt(header) : -1;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public Enumeration getHeaders(String name) {
        return new EmptyEnumeration();
    }

    public Enumeration getHeaderNames() {
        if (this.headers != null) {
            return new IteratorWrapper(this.headers.keySet().iterator());
        }
        return new EmptyEnumeration();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public String getProtocol() {
        return "cli";
    }

    public String getScheme() {
        return "cli";
    }

    public String getServerName() {
        return "Apache Cocoon 2.0.4";
    }

    public int getServerPort() {
        return -1;
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getMethod() {
        return "get";
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public Cookie[] getCookies() {
        return null;
    }

    public Map getCookieMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean create) {
        return CommandLineSession.getSession(create);
    }

    public String getRequestedSessionId() {
        return CommandLineSession.getSession(false) != null ? CommandLineSession.getSession(false).getId() : null;
    }

    public boolean isRequestedSessionIdValid() {
        return CommandLineSession.getSession(false) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        throw new RuntimeException(this.getClass().getName() + ".getLocales() method not yet implemented!");
    }

    public String getAuthType() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    private class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }

    private class IteratorWrapper
    implements Enumeration {
        private Iterator iterator;

        public IteratorWrapper(Iterator i) {
            this.iterator = i;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

