/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DirectoryGenerator
extends ComposerGenerator {
    private static final String FILE = "file:";
    protected static final String URI = "http://apache.org/cocoon/directory/2.0";
    protected static final String PREFIX = "dir";
    protected static final String DIR_NODE_NAME = "directory";
    protected static final String FILE_NODE_NAME = "file";
    protected static final String FILENAME_ATTR_NAME = "name";
    protected static final String LASTMOD_ATTR_NAME = "lastModified";
    protected static final String DATE_ATTR_NAME = "date";
    protected int depth;
    protected AttributesImpl attributes = new AttributesImpl();
    protected SimpleDateFormat dateFormatter;
    protected RE rootRE;
    protected RE includeRE;
    protected RE excludeRE;
    protected boolean isRequestedDirectory;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        String dateFormatString = par.getParameter("dateFormat", null);
        this.dateFormatter = dateFormatString != null ? new SimpleDateFormat(dateFormatString) : new SimpleDateFormat();
        this.depth = par.getParameterAsInteger("depth", 1);
        this.getLogger().debug("depth: " + this.depth);
        String rePattern = par.getParameter("root", null);
        try {
            this.getLogger().debug("root pattern: " + rePattern);
            this.rootRE = rePattern == null ? null : new RE(rePattern);
            rePattern = par.getParameter("include", null);
            this.getLogger().debug("include pattern: " + rePattern);
            this.includeRE = rePattern == null ? null : new RE(rePattern);
            rePattern = par.getParameter("exclude", null);
            this.getLogger().debug("exclude pattern: " + rePattern);
            this.excludeRE = rePattern == null ? null : new RE(rePattern);
        }
        catch (RESyntaxException rese) {
            this.getLogger().error("Syntax error in regexp pattern '" + rePattern + "'", (Throwable)rese);
            throw new ProcessingException("Syntax error in regexp pattern '" + rePattern + "'", rese);
        }
        this.isRequestedDirectory = false;
        this.attributes = new AttributesImpl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate() throws SAXException, ProcessingException {
        String directory = this.source;
        Source inputSource = null;
        try {
            try {
                inputSource = this.resolver.resolve(directory);
                String systemId = inputSource.getSystemId();
                if (!systemId.startsWith(FILE)) {
                    throw new ResourceNotFoundException(systemId + " does not denote a directory");
                }
                File directoryFile = new File(new URL(systemId).getFile());
                if (!directoryFile.isDirectory()) {
                    throw new ResourceNotFoundException(directory + " is not a directory.");
                }
                this.contentHandler.startDocument();
                this.contentHandler.startPrefixMapping(PREFIX, URI);
                Stack ancestors = this.getAncestors(directoryFile);
                this.addPathWithAncestors(directoryFile, ancestors);
                this.contentHandler.endPrefixMapping(PREFIX);
                this.contentHandler.endDocument();
            }
            catch (IOException ioe) {
                this.getLogger().warn("Could not read directory " + directory, (Throwable)ioe);
                throw new ResourceNotFoundException("Could not read directory " + directory, ioe);
            }
            Object var7_7 = null;
            if (inputSource == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (inputSource == null) throw throwable;
            inputSource.recycle();
            throw throwable;
        }
        inputSource.recycle();
    }

    protected Stack getAncestors(File path) {
        File parent = path;
        Stack<File> ancestors = new Stack<File>();
        while (parent != null && !this.isRoot(parent)) {
            if ((parent = parent.getParentFile()) == null) continue;
            ancestors.push(parent);
        }
        return ancestors;
    }

    protected void addPathWithAncestors(File path, Stack ancestors) throws SAXException {
        if (ancestors.empty()) {
            this.isRequestedDirectory = true;
            this.addPath(path, this.depth);
        } else {
            this.startNode(DIR_NODE_NAME, (File)ancestors.pop());
            this.addPathWithAncestors(path, ancestors);
            this.endNode(DIR_NODE_NAME);
        }
    }

    protected void addPath(File path, int depth) throws SAXException {
        if (path.isDirectory()) {
            this.startNode(DIR_NODE_NAME, path);
            if (depth > 0) {
                File[] contents = path.listFiles();
                int i = 0;
                while (i < contents.length) {
                    if (this.isIncluded(contents[i]) && !this.isExcluded(contents[i])) {
                        this.addPath(contents[i], depth - 1);
                    }
                    ++i;
                }
            }
            this.endNode(DIR_NODE_NAME);
        } else if (this.isIncluded(path) && !this.isExcluded(path)) {
            this.startNode(FILE_NODE_NAME, path);
            this.endNode(FILE_NODE_NAME);
        }
    }

    protected void startNode(String nodeName, File path) throws SAXException {
        this.setNodeAttributes(path);
        this.contentHandler.startElement(URI, nodeName, "dir:" + nodeName, this.attributes);
    }

    protected void setNodeAttributes(File path) throws SAXException {
        long lastModified = path.lastModified();
        this.attributes.clear();
        this.attributes.addAttribute("", FILENAME_ATTR_NAME, FILENAME_ATTR_NAME, "CDATA", path.getName());
        this.attributes.addAttribute("", LASTMOD_ATTR_NAME, LASTMOD_ATTR_NAME, "CDATA", Long.toString(path.lastModified()));
        this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(new Date(lastModified)));
        if (this.isRequestedDirectory) {
            this.attributes.addAttribute("", "requested", "requested", "CDATA", "true");
            this.isRequestedDirectory = false;
        }
    }

    protected void endNode(String nodeName) throws SAXException {
        this.contentHandler.endElement(URI, nodeName, "dir:" + nodeName);
    }

    protected boolean isRoot(File path) {
        return this.rootRE == null ? true : this.rootRE.match(path.getName());
    }

    protected boolean isIncluded(File path) {
        return this.includeRE == null ? true : this.includeRE.match(path.getName());
    }

    protected boolean isExcluded(File path) {
        return this.excludeRE == null ? false : this.excludeRE.match(path.getName());
    }

    public void recycle() {
        super.recycle();
        this.attributes = null;
        this.dateFormatter = null;
        this.rootRE = null;
        this.includeRE = null;
        this.excludeRE = null;
    }
}

