/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.component.ExcaliburComponentSelector;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.sitemap.SitemapComponentSelector;

public class DefaultSitemapComponentSelector
extends ExcaliburComponentSelector
implements SitemapComponentSelector {
    private Map hintLabels = new HashMap();
    private Map mime_types = new HashMap();
    private SitemapComponentSelector parentSelector;
    private Map componentMapping = Collections.synchronizedMap(new HashMap());

    public void setParentSelector(SitemapComponentSelector newSelector) {
        if (this.parentSelector == null) {
            this.parentSelector = newSelector;
        }
    }

    public Component select(Object hint) throws ComponentException {
        Component component = null;
        try {
            component = super.select(hint);
        }
        catch (ComponentException ce) {
            if (this.parentSelector != null) {
                component = this.parentSelector.select(hint);
                this.componentMapping.put(component, this.parentSelector);
            }
            throw ce;
        }
        return component;
    }

    public void release(Component component) {
        SitemapComponentSelector selector = (SitemapComponentSelector)this.componentMapping.get(component);
        if (selector != null) {
            this.componentMapping.remove(component);
            selector.release(component);
        } else {
            super.release(component);
        }
    }

    public void initialize() {
        super.initialize();
        this.mime_types = Collections.unmodifiableMap(this.mime_types);
    }

    public String getMimeTypeForHint(Object hint) {
        String mimeType = (String)this.mime_types.get(hint);
        if (mimeType != null) {
            return mimeType;
        }
        if (this.parentSelector != null) {
            return this.parentSelector.getMimeTypeForHint(hint);
        }
        return null;
    }

    public boolean hasLabel(Object hint, String label) {
        String[] labels = (String[])this.hintLabels.get(hint);
        if (labels != null) {
            int i = 0;
            while (i < labels.length) {
                if (labels[i].equals(label)) {
                    return true;
                }
                ++i;
            }
        } else if (this.parentSelector != null) {
            return this.parentSelector.hasLabel(hint, label);
        }
        return false;
    }

    public String[] getLabels(Object hint) {
        String[] labels = (String[])this.hintLabels.get(hint);
        if (labels == null && this.parentSelector != null) {
            return this.parentSelector.getLabels(hint);
        }
        return labels;
    }

    public void addComponent(Object hint, Class component, Configuration conf) throws ComponentException {
        String label;
        String mimeType = conf.getAttribute("mime-type", null);
        if (mimeType != null) {
            this.mime_types.put(hint, mimeType);
        }
        if ((label = conf.getAttribute("label", null)) != null) {
            StringTokenizer st = new StringTokenizer(label, " ,", false);
            String[] labels = new String[st.countTokens()];
            int i = 0;
            while (i < labels.length) {
                labels[i] = st.nextToken();
                ++i;
            }
            this.hintLabels.put(hint, labels);
        }
        super.addComponent(hint, component, conf);
    }

    public void addSitemapComponent(Object hint, Class component, Configuration conf, String mimeType) throws ComponentException, ConfigurationException {
        this.addComponent(hint, component, conf);
        this.mime_types.put(hint, mimeType);
    }
}

