/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.ProcessHttpRequest;
import com.hp.hpl.deli.ProcessProfile;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.Workspace;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class Profile
extends Vector {
    protected Workspace workspace;
    private HashMap attributeNameToAttributePosition;

    public Profile(Workspace workspace, String string) {
        this.workspace = workspace;
        this.workspace.printDebug("Profile: Processing profile reference");
        ProcessProfile processProfile = null;
        try {
            processProfile = this.workspace.processProfileFactory();
        }
        catch (Exception exception) {
            this.workspace.printDebug("Profile: Could not create an object to process profile");
        }
        try {
            this.addAll(processProfile.process(string));
        }
        catch (Exception exception) {
            this.workspace.printDebug("Profile: Could not process " + string);
        }
        this.finishConstruction();
    }

    public Profile(Workspace workspace, HttpServletRequest httpServletRequest) {
        Object object;
        this.workspace = workspace;
        this.workspace.printDebug("Profile: Processing HTTP request");
        ProcessHttpRequest processHttpRequest = new ProcessHttpRequest(this.workspace, httpServletRequest);
        Vector vector = processHttpRequest.getReferences();
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.get(n);
            this.workspace.printDebug("Retrieving profile " + (String)object);
            try {
                this.addAll(this.workspace.profileCache.get((String)object));
            }
            catch (Exception exception) {
                this.workspace.printDebug("Profile: While using cache " + exception);
            }
            ++n;
        }
        if (processHttpRequest.getDiffs().size() > 0) {
            object = null;
            try {
                object = this.workspace.processProfileFactory();
            }
            catch (Exception exception) {
                this.workspace.printDebug("Profile: Could not create an object to process profile");
            }
            try {
                this.addAll(((ProcessProfile)object).process(processHttpRequest.getDiffs()));
            }
            catch (Exception exception) {
                this.workspace.printDebug("Profile: Could not process profile-diffs");
            }
        }
        this.finishConstruction();
    }

    private void finishConstruction() {
        if (this.workspace.printProfileBeforeMerge) {
            this.workspace.printDebug(this.toString());
        }
        ProfileAttribute[] profileAttributeArray = new ProfileAttribute[this.workspace.vocabulary.numberOfAttributes()];
        int n = 0;
        while (n < this.size()) {
            ProfileAttribute profileAttribute = (ProfileAttribute)this.get(n);
            int n2 = profileAttribute.getAttributeRef();
            ProfileAttribute profileAttribute2 = profileAttributeArray[n2];
            if (profileAttribute2 == null) {
                profileAttributeArray[n2] = profileAttribute;
            } else {
                profileAttributeArray[n2].set(profileAttribute);
            }
            ++n;
        }
        this.clear();
        this.attributeNameToAttributePosition = new HashMap();
        int n3 = 0;
        while (n3 < this.workspace.vocabulary.numberOfAttributes()) {
            if (profileAttributeArray[n3] != null) {
                Integer n4 = new Integer(this.size());
                this.attributeNameToAttributePosition.put(profileAttributeArray[n3].getAttribute(), n4);
                this.add(profileAttributeArray[n3]);
            }
            ++n3;
        }
    }

    public ProfileAttribute getAttribute(String string) {
        Integer n = (Integer)this.attributeNameToAttributePosition.get(string);
        return (ProfileAttribute)this.get(n);
    }

    public String getMessages() {
        String string = this.workspace.retrieveDebug();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            ProfileAttribute profileAttribute = (ProfileAttribute)this.get(n);
            stringBuffer.append(profileAttribute.toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

