/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ExtendedFormatRecord
extends Record {
    public static final short sid = 224;
    public static final short NULL = -16;
    public static final short XF_STYLE = 1;
    public static final short XF_CELL = 0;
    public static final short NONE = 0;
    public static final short THIN = 1;
    public static final short MEDIUM = 2;
    public static final short DASHED = 3;
    public static final short DOTTED = 4;
    public static final short THICK = 5;
    public static final short DOUBLE = 6;
    public static final short HAIR = 7;
    public static final short MEDIUM_DASHED = 8;
    public static final short DASH_DOT = 9;
    public static final short MEDIUM_DASH_DOT = 10;
    public static final short DASH_DOT_DOT = 11;
    public static final short MEDIUM_DASH_DOT_DOT = 12;
    public static final short SLANTED_DASH_DOT = 13;
    public static final short GENERAL = 0;
    public static final short LEFT = 1;
    public static final short CENTER = 2;
    public static final short RIGHT = 3;
    public static final short FILL = 4;
    public static final short JUSTIFY = 5;
    public static final short CENTER_SELECTION = 6;
    public static final short VERTICAL_TOP = 0;
    public static final short VERTICAL_CENTER = 1;
    public static final short VERTICAL_BOTTOM = 2;
    public static final short VERTICAL_JUSTIFY = 3;
    public static final short NO_FILL = 0;
    public static final short SOLID_FILL = 1;
    public static final short FINE_DOTS = 2;
    public static final short ALT_BARS = 3;
    public static final short SPARSE_DOTS = 4;
    public static final short THICK_HORZ_BANDS = 5;
    public static final short THICK_VERT_BANDS = 6;
    public static final short THICK_BACKWARD_DIAG = 7;
    public static final short THICK_FORWARD_DIAG = 8;
    public static final short BIG_SPOTS = 9;
    public static final short BRICKS = 10;
    public static final short THIN_HORZ_BANDS = 11;
    public static final short THIN_VERT_BANDS = 12;
    public static final short THIN_BACKWARD_DIAG = 13;
    public static final short THIN_FORWARD_DIAG = 14;
    public static final short SQUARES = 15;
    public static final short DIAMONDS = 16;
    private short field_1_font_index;
    private short field_2_format_index;
    private static final BitField _locked;
    private static final BitField _hidden;
    private static final BitField _xf_type;
    private static final BitField _123_prefix;
    private static final BitField _parent_index;
    private short field_3_cell_options;
    private static final BitField _alignment;
    private static final BitField _wrap_text;
    private static final BitField _vertical_alignment;
    private static final BitField _justify_last;
    private static final BitField _rotation;
    private short field_4_alignment_options;
    private static final BitField _indent;
    private static final BitField _shrink_to_fit;
    private static final BitField _merge_cells;
    private static final BitField _reading_order;
    private static final BitField _indent_not_parent_format;
    private static final BitField _indent_not_parent_font;
    private static final BitField _indent_not_parent_alignment;
    private static final BitField _indent_not_parent_border;
    private static final BitField _indent_not_parent_pattern;
    private static final BitField _indent_not_parent_cell_options;
    private short field_5_indention_options;
    private static final BitField _border_left;
    private static final BitField _border_right;
    private static final BitField _border_top;
    private static final BitField _border_bottom;
    private short field_6_border_options;
    private static final BitField _left_border_palette_idx;
    private static final BitField _right_border_palette_idx;
    private static final BitField _diag;
    private short field_7_palette_options;
    private static final BitField _top_border_palette_idx;
    private static final BitField _bottom_border_palette_idx;
    private static final BitField _adtl_diag;
    private static final BitField _adtl_diag_line_style;
    private static final BitField _adtl_fill_pattern;
    private int field_8_adtl_palette_options;
    private static final BitField _fill_foreground;
    private static final BitField _fill_background;
    private short field_9_fill_palette_options;

    public ExtendedFormatRecord() {
    }

    public ExtendedFormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExtendedFormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 224) {
            throw new RecordFormatException("NOT A EXTENDED FORMAT RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_font_index = LittleEndian.getShort(data, 0 + offset);
        this.field_2_format_index = LittleEndian.getShort(data, 2 + offset);
        this.field_3_cell_options = LittleEndian.getShort(data, 4 + offset);
        this.field_4_alignment_options = LittleEndian.getShort(data, 6 + offset);
        this.field_5_indention_options = LittleEndian.getShort(data, 8 + offset);
        this.field_6_border_options = LittleEndian.getShort(data, 10 + offset);
        this.field_7_palette_options = LittleEndian.getShort(data, 12 + offset);
        this.field_8_adtl_palette_options = LittleEndian.getInt(data, 14 + offset);
        this.field_9_fill_palette_options = LittleEndian.getShort(data, 18 + offset);
    }

    public void setFontIndex(short index) {
        this.field_1_font_index = index;
    }

    public void setFormatIndex(short index) {
        this.field_2_format_index = index;
    }

    public void setCellOptions(short options) {
        this.field_3_cell_options = options;
    }

    public void setLocked(boolean locked) {
        this.field_3_cell_options = _locked.setShortBoolean(this.field_3_cell_options, locked);
    }

    public void setHidden(boolean hidden) {
        this.field_3_cell_options = _hidden.setShortBoolean(this.field_3_cell_options, hidden);
    }

    public void setXFType(short type) {
        this.field_3_cell_options = _xf_type.setShortValue(this.field_3_cell_options, type);
    }

    public void set123Prefix(boolean prefix) {
        this.field_3_cell_options = _123_prefix.setShortBoolean(this.field_3_cell_options, prefix);
    }

    public void setParentIndex(short parent) {
        this.field_3_cell_options = _parent_index.setShortValue(this.field_3_cell_options, parent);
    }

    public void setAlignmentOptions(short options) {
        this.field_4_alignment_options = options;
    }

    public void setAlignment(short align) {
        this.field_4_alignment_options = _alignment.setShortValue(this.field_4_alignment_options, align);
    }

    public void setWrapText(boolean wrapped) {
        this.field_4_alignment_options = _wrap_text.setShortBoolean(this.field_4_alignment_options, wrapped);
    }

    public void setVerticalAlignment(short align) {
        this.field_4_alignment_options = _vertical_alignment.setShortValue(this.field_4_alignment_options, align);
    }

    public void setJustifyLast(short justify) {
        this.field_4_alignment_options = _justify_last.setShortValue(this.field_4_alignment_options, justify);
    }

    public void setRotation(short rotation) {
        this.field_4_alignment_options = _rotation.setShortValue(this.field_4_alignment_options, rotation);
    }

    public void setIndentionOptions(short options) {
        this.field_5_indention_options = options;
    }

    public void setIndent(short indent) {
        this.field_5_indention_options = _indent.setShortValue(this.field_5_indention_options, indent);
    }

    public void setShrinkToFit(boolean shrink) {
        this.field_5_indention_options = _shrink_to_fit.setShortBoolean(this.field_5_indention_options, shrink);
    }

    public void setMergeCells(boolean merge) {
        this.field_5_indention_options = _merge_cells.setShortBoolean(this.field_5_indention_options, merge);
    }

    public void setReadingOrder(short order) {
        this.field_5_indention_options = _reading_order.setShortValue(this.field_5_indention_options, order);
    }

    public void setIndentNotParentFormat(boolean parent) {
        this.field_5_indention_options = _indent_not_parent_format.setShortBoolean(this.field_5_indention_options, parent);
    }

    public void setIndentNotParentFont(boolean font) {
        this.field_5_indention_options = _indent_not_parent_font.setShortBoolean(this.field_5_indention_options, font);
    }

    public void setIndentNotParentAlignment(boolean alignment) {
        this.field_5_indention_options = _indent_not_parent_alignment.setShortBoolean(this.field_5_indention_options, alignment);
    }

    public void setIndentNotParentBorder(boolean border) {
        this.field_5_indention_options = _indent_not_parent_border.setShortBoolean(this.field_5_indention_options, border);
    }

    public void setIndentNotParentPattern(boolean pattern) {
        this.field_5_indention_options = _indent_not_parent_pattern.setShortBoolean(this.field_5_indention_options, pattern);
    }

    public void setIndentNotParentCellOptions(boolean options) {
        this.field_5_indention_options = _indent_not_parent_cell_options.setShortBoolean(this.field_5_indention_options, options);
    }

    public void setBorderOptions(short options) {
        this.field_6_border_options = options;
    }

    public void setBorderLeft(short border) {
        this.field_6_border_options = _border_left.setShortValue(this.field_6_border_options, border);
    }

    public void setBorderRight(short border) {
        this.field_6_border_options = _border_right.setShortValue(this.field_6_border_options, border);
    }

    public void setBorderTop(short border) {
        this.field_6_border_options = _border_top.setShortValue(this.field_6_border_options, border);
    }

    public void setBorderBottom(short border) {
        this.field_6_border_options = _border_bottom.setShortValue(this.field_6_border_options, border);
    }

    public void setPaletteOptions(short options) {
        this.field_7_palette_options = options;
    }

    public void setLeftBorderPaletteIdx(short border) {
        this.field_7_palette_options = _left_border_palette_idx.setShortValue(this.field_7_palette_options, border);
    }

    public void setRightBorderPaletteIdx(short border) {
        this.field_7_palette_options = _right_border_palette_idx.setShortValue(this.field_7_palette_options, border);
    }

    public void setDiag(short diag) {
        this.field_7_palette_options = _diag.setShortValue(this.field_7_palette_options, diag);
    }

    public void setAdtlPaletteOptions(short options) {
        this.field_8_adtl_palette_options = options;
    }

    public void setTopBorderPaletteIdx(short border) {
        this.field_8_adtl_palette_options = _top_border_palette_idx.setValue(this.field_8_adtl_palette_options, border);
    }

    public void setBottomBorderPaletteIdx(short border) {
        this.field_8_adtl_palette_options = _bottom_border_palette_idx.setValue(this.field_8_adtl_palette_options, border);
    }

    public void setAdtlDiag(short diag) {
        this.field_8_adtl_palette_options = _adtl_diag.setValue(this.field_8_adtl_palette_options, diag);
    }

    public void setAdtlDiagLineStyle(short diag) {
        this.field_8_adtl_palette_options = _adtl_diag_line_style.setValue(this.field_8_adtl_palette_options, diag);
    }

    public void setAdtlFillPattern(short fill) {
        this.field_8_adtl_palette_options = _adtl_fill_pattern.setValue(this.field_8_adtl_palette_options, fill);
    }

    public void setFillPaletteOptions(short options) {
        this.field_9_fill_palette_options = options;
    }

    public void setFillForeground(short color) {
        this.field_9_fill_palette_options = _fill_foreground.setShortValue(this.field_9_fill_palette_options, color);
    }

    public void setFillBackground(short color) {
        this.field_9_fill_palette_options = _fill_background.setShortValue(this.field_9_fill_palette_options, color);
    }

    public short getFontIndex() {
        return this.field_1_font_index;
    }

    public short getFormatIndex() {
        return this.field_2_format_index;
    }

    public short getCellOptions() {
        return this.field_3_cell_options;
    }

    public boolean isLocked() {
        return _locked.isSet(this.field_3_cell_options);
    }

    public boolean isHidden() {
        return _hidden.isSet(this.field_3_cell_options);
    }

    public short getXFType() {
        return _xf_type.getShortValue(this.field_3_cell_options);
    }

    public boolean get123Prefix() {
        return _123_prefix.isSet(this.field_3_cell_options);
    }

    public short getParentIndex() {
        return _parent_index.getShortValue(this.field_3_cell_options);
    }

    public short getAlignmentOptions() {
        return this.field_4_alignment_options;
    }

    public short getAlignment() {
        return _alignment.getShortValue(this.field_4_alignment_options);
    }

    public boolean getWrapText() {
        return _wrap_text.isSet(this.field_4_alignment_options);
    }

    public short getVerticalAlignment() {
        return _vertical_alignment.getShortValue(this.field_4_alignment_options);
    }

    public short getJustifyLast() {
        return _justify_last.getShortValue(this.field_4_alignment_options);
    }

    public short getRotation() {
        return _rotation.getShortValue(this.field_4_alignment_options);
    }

    public short getIndentionOptions() {
        return this.field_5_indention_options;
    }

    public short getIndent() {
        return _indent.getShortValue(this.field_5_indention_options);
    }

    public boolean getShrinkToFit() {
        return _shrink_to_fit.isSet(this.field_5_indention_options);
    }

    public boolean getMergeCells() {
        return _merge_cells.isSet(this.field_5_indention_options);
    }

    public short getReadingOrder() {
        return _reading_order.getShortValue(this.field_5_indention_options);
    }

    public boolean isIndentNotParentFormat() {
        return _indent_not_parent_format.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentFont() {
        return _indent_not_parent_font.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentAlignment() {
        return _indent_not_parent_alignment.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentBorder() {
        return _indent_not_parent_border.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentPattern() {
        return _indent_not_parent_pattern.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentCellOptions() {
        return _indent_not_parent_cell_options.isSet(this.field_5_indention_options);
    }

    public short getBorderOptions() {
        return this.field_6_border_options;
    }

    public short getBorderLeft() {
        return _border_left.getShortValue(this.field_6_border_options);
    }

    public short getBorderRight() {
        return _border_right.getShortValue(this.field_6_border_options);
    }

    public short getBorderTop() {
        return _border_top.getShortValue(this.field_6_border_options);
    }

    public short getBorderBottom() {
        return _border_bottom.getShortValue(this.field_6_border_options);
    }

    public short getPaletteOptions() {
        return this.field_7_palette_options;
    }

    public short getLeftBorderPaletteIdx() {
        return _left_border_palette_idx.getShortValue(this.field_7_palette_options);
    }

    public short getRightBorderPaletteIdx() {
        return _right_border_palette_idx.getShortValue(this.field_7_palette_options);
    }

    public short getDiag() {
        return _diag.getShortValue(this.field_7_palette_options);
    }

    public int getAdtlPaletteOptions() {
        return this.field_8_adtl_palette_options;
    }

    public short getTopBorderPaletteIdx() {
        return (short)_top_border_palette_idx.getValue(this.field_8_adtl_palette_options);
    }

    public short getBottomBorderPaletteIdx() {
        return (short)_bottom_border_palette_idx.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlDiag() {
        return (short)_adtl_diag.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlDiagLineStyle() {
        return (short)_adtl_diag_line_style.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlFillPattern() {
        return (short)_adtl_fill_pattern.getValue(this.field_8_adtl_palette_options);
    }

    public short getFillPaletteOptions() {
        return this.field_9_fill_palette_options;
    }

    public short getFillForeground() {
        return _fill_foreground.getShortValue(this.field_9_fill_palette_options);
    }

    public short getFillBackground() {
        return _fill_background.getShortValue(this.field_9_fill_palette_options);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTENDEDFORMAT]\n");
        if (this.getXFType() == 1) {
            buffer.append(" STYLE_RECORD_TYPE\n");
        } else if (this.getXFType() == 0) {
            buffer.append(" CELL_RECORD_TYPE\n");
        }
        buffer.append("    .fontindex       = ").append(Integer.toHexString(this.getFontIndex())).append("\n");
        buffer.append("    .formatindex     = ").append(Integer.toHexString(this.getFormatIndex())).append("\n");
        buffer.append("    .celloptions     = ").append(Integer.toHexString(this.getCellOptions())).append("\n");
        buffer.append("          .islocked  = ").append(this.isLocked()).append("\n");
        buffer.append("          .ishidden  = ").append(this.isHidden()).append("\n");
        buffer.append("          .recordtype= ").append(Integer.toHexString(this.getXFType())).append("\n");
        buffer.append("          .parentidx = ").append(Integer.toHexString(this.getParentIndex())).append("\n");
        buffer.append("    .alignmentoptions= ").append(Integer.toHexString(this.getAlignmentOptions())).append("\n");
        buffer.append("          .alignment = ").append(this.getAlignment()).append("\n");
        buffer.append("          .wraptext  = ").append(this.getWrapText()).append("\n");
        buffer.append("          .valignment= ").append(Integer.toHexString(this.getVerticalAlignment())).append("\n");
        buffer.append("          .justlast  = ").append(Integer.toHexString(this.getJustifyLast())).append("\n");
        buffer.append("          .rotation  = ").append(Integer.toHexString(this.getRotation())).append("\n");
        buffer.append("    .indentionoptions= ").append(Integer.toHexString(this.getIndentionOptions())).append("\n");
        buffer.append("          .indent    = ").append(Integer.toHexString(this.getIndent())).append("\n");
        buffer.append("          .shrinktoft= ").append(this.getShrinkToFit()).append("\n");
        buffer.append("          .mergecells= ").append(this.getMergeCells()).append("\n");
        buffer.append("          .readngordr= ").append(Integer.toHexString(this.getReadingOrder())).append("\n");
        buffer.append("          .formatflag= ").append(this.isIndentNotParentFormat()).append("\n");
        buffer.append("          .fontflag  = ").append(this.isIndentNotParentFont()).append("\n");
        buffer.append("          .prntalgnmt= ").append(this.isIndentNotParentAlignment()).append("\n");
        buffer.append("          .borderflag= ").append(this.isIndentNotParentBorder()).append("\n");
        buffer.append("          .paternflag= ").append(this.isIndentNotParentPattern()).append("\n");
        buffer.append("          .celloption= ").append(this.isIndentNotParentCellOptions()).append("\n");
        buffer.append("    .borderoptns     = ").append(Integer.toHexString(this.getBorderOptions())).append("\n");
        buffer.append("          .lftln     = ").append(Integer.toHexString(this.getBorderLeft())).append("\n");
        buffer.append("          .rgtln     = ").append(Integer.toHexString(this.getBorderRight())).append("\n");
        buffer.append("          .topln     = ").append(Integer.toHexString(this.getBorderTop())).append("\n");
        buffer.append("          .btmln     = ").append(Integer.toHexString(this.getBorderBottom())).append("\n");
        buffer.append("    .paleteoptns     = ").append(Integer.toHexString(this.getPaletteOptions())).append("\n");
        buffer.append("          .leftborder= ").append(Integer.toHexString(this.getLeftBorderPaletteIdx())).append("\n");
        buffer.append("          .rghtborder= ").append(Integer.toHexString(this.getRightBorderPaletteIdx())).append("\n");
        buffer.append("          .diag      = ").append(Integer.toHexString(this.getDiag())).append("\n");
        buffer.append("    .paleteoptn2     = ").append(Integer.toHexString(this.getAdtlPaletteOptions())).append("\n");
        buffer.append("          .topborder = ").append(Integer.toHexString(this.getTopBorderPaletteIdx())).append("\n");
        buffer.append("          .botmborder= ").append(Integer.toHexString(this.getBottomBorderPaletteIdx())).append("\n");
        buffer.append("          .adtldiag  = ").append(Integer.toHexString(this.getAdtlDiag())).append("\n");
        buffer.append("          .diaglnstyl= ").append(Integer.toHexString(this.getAdtlDiagLineStyle())).append("\n");
        buffer.append("          .fillpattrn= ").append(Integer.toHexString(this.getAdtlFillPattern())).append("\n");
        buffer.append("    .fillpaloptn     = ").append(Integer.toHexString(this.getFillPaletteOptions())).append("\n");
        buffer.append("          .foreground= ").append(Integer.toHexString(this.getFillForeground())).append("\n");
        buffer.append("          .background= ").append(Integer.toHexString(this.getFillBackground())).append("\n");
        buffer.append("[/EXTENDEDFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)224);
        LittleEndian.putShort(data, 2 + offset, (short)20);
        LittleEndian.putShort(data, 4 + offset, this.getFontIndex());
        LittleEndian.putShort(data, 6 + offset, this.getFormatIndex());
        LittleEndian.putShort(data, 8 + offset, this.getCellOptions());
        LittleEndian.putShort(data, 10 + offset, this.getAlignmentOptions());
        LittleEndian.putShort(data, 12 + offset, this.getIndentionOptions());
        LittleEndian.putShort(data, 14 + offset, this.getBorderOptions());
        LittleEndian.putShort(data, 16 + offset, this.getPaletteOptions());
        LittleEndian.putInt(data, 18 + offset, this.getAdtlPaletteOptions());
        LittleEndian.putShort(data, 22 + offset, this.getFillPaletteOptions());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getSid() {
        return 224;
    }

    static {
        sid = (short)224;
        NULL = (short)-16;
        XF_STYLE = 1;
        XF_CELL = 0;
        NONE = 0;
        THIN = 1;
        MEDIUM = (short)2;
        DASHED = (short)3;
        DOTTED = (short)4;
        THICK = (short)5;
        DOUBLE = (short)6;
        HAIR = (short)7;
        MEDIUM_DASHED = (short)8;
        DASH_DOT = (short)9;
        MEDIUM_DASH_DOT = (short)10;
        DASH_DOT_DOT = (short)11;
        MEDIUM_DASH_DOT_DOT = (short)12;
        SLANTED_DASH_DOT = (short)13;
        GENERAL = 0;
        LEFT = 1;
        CENTER = (short)2;
        RIGHT = (short)3;
        FILL = (short)4;
        JUSTIFY = (short)5;
        CENTER_SELECTION = (short)6;
        VERTICAL_TOP = 0;
        VERTICAL_CENTER = 1;
        VERTICAL_BOTTOM = (short)2;
        VERTICAL_JUSTIFY = (short)3;
        NO_FILL = 0;
        SOLID_FILL = 1;
        FINE_DOTS = (short)2;
        ALT_BARS = (short)3;
        SPARSE_DOTS = (short)4;
        THICK_HORZ_BANDS = (short)5;
        THICK_VERT_BANDS = (short)6;
        THICK_BACKWARD_DIAG = (short)7;
        THICK_FORWARD_DIAG = (short)8;
        BIG_SPOTS = (short)9;
        BRICKS = (short)10;
        THIN_HORZ_BANDS = (short)11;
        THIN_VERT_BANDS = (short)12;
        THIN_BACKWARD_DIAG = (short)13;
        THIN_FORWARD_DIAG = (short)14;
        SQUARES = (short)15;
        DIAMONDS = (short)16;
        _locked = new BitField(1);
        _hidden = new BitField(2);
        _xf_type = new BitField(4);
        _123_prefix = new BitField(8);
        _parent_index = new BitField(65520);
        _alignment = new BitField(7);
        _wrap_text = new BitField(8);
        _vertical_alignment = new BitField(112);
        _justify_last = new BitField(128);
        _rotation = new BitField(65280);
        _indent = new BitField(15);
        _shrink_to_fit = new BitField(16);
        _merge_cells = new BitField(32);
        _reading_order = new BitField(192);
        _indent_not_parent_format = new BitField(1024);
        _indent_not_parent_font = new BitField(2048);
        _indent_not_parent_alignment = new BitField(4096);
        _indent_not_parent_border = new BitField(8192);
        _indent_not_parent_pattern = new BitField(16384);
        _indent_not_parent_cell_options = new BitField(32768);
        _border_left = new BitField(15);
        _border_right = new BitField(240);
        _border_top = new BitField(3840);
        _border_bottom = new BitField(61440);
        _left_border_palette_idx = new BitField(127);
        _right_border_palette_idx = new BitField(16256);
        _diag = new BitField(49152);
        _top_border_palette_idx = new BitField(127);
        _bottom_border_palette_idx = new BitField(16256);
        _adtl_diag = new BitField(2080768);
        _adtl_diag_line_style = new BitField(0x1E00000);
        _adtl_fill_pattern = new BitField(-67108864);
        _fill_foreground = new BitField(127);
        _fill_background = new BitField(16256);
    }
}

