/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class IterationRecord
extends Record {
    public static final short sid = 17;
    private short field_1_iteration;

    public IterationRecord() {
    }

    public IterationRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public IterationRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 17) {
            throw new RecordFormatException("NOT An ITERATION RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_iteration = LittleEndian.getShort(data, 0 + offset);
    }

    public void setIteration(boolean iterate) {
        this.field_1_iteration = iterate ? (short)1 : 0;
    }

    public boolean getIteration() {
        return this.field_1_iteration == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ITERATION]\n");
        buffer.append("    .iteration      = ").append(this.getIteration()).append("\n");
        buffer.append("[/ITERATION]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)17);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_iteration);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 17;
    }

    static {
        sid = (short)17;
    }
}

